/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.dataset.provider;

import com.datastax.data.dataset.DataTable;
import com.datastax.data.dataset.provider.AbstractTask;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.SwingUtilities;

public abstract class LoadTask
extends AbstractTask {
    private static final Logger LOG = Logger.getLogger(LoadTask.class.getName());
    private LinkedList loadQueue = new LinkedList();
    private LoadNotifier loadNotifier = new LoadNotifier();
    private DataTable[] tables;
    private boolean loadOnEDT = true;

    public void setLoadOnEDT(boolean val) {
        this.loadOnEDT = val;
    }

    public LoadTask(DataTable[] tables) {
        this.tables = tables == null ? new DataTable[]{} : tables;
    }

    @Override
    public void run() {
        this.setIndeterminate(true);
        try {
            this.readData(this.tables);
            this.scheduleLoad();
            this.setProgress(this.getMaximum());
        }
        catch (Exception e2) {
            Exception error = e2;
            LOG.log(Level.WARNING, "Failed to load data into tables {0}. {1}", new Object[]{this.tables, e2.getStackTrace()});
            this.setProgress(this.getMaximum());
        }
    }

    protected abstract void readData(DataTable[] var1) throws Exception;

    protected abstract void loadData(LoadItem[] var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scheduleLoad(LoadItem item) {
        LinkedList linkedList = this.loadQueue;
        synchronized (linkedList) {
            if (item != null) {
                this.loadQueue.addLast(item);
            }
            if (!this.loadNotifier.isPending()) {
                this.loadNotifier.setPending(true);
                if (this.loadOnEDT) {
                    SwingUtilities.invokeLater(this.loadNotifier);
                } else {
                    this.loadNotifier.run();
                }
            }
        }
    }

    protected void scheduleLoad() {
        this.scheduleLoad(null);
    }

    public String getDescription() {
        return "<html><h3>Loading data</h3></html>";
    }

    public Icon getIcon() {
        return null;
    }

    public String getMessage() {
        return "Loading item " + (this.getProgress() + 1) + " of " + this.getMaximum();
    }

    public boolean cancel() throws Exception {
        return false;
    }

    private class LoadNotifier
    implements Runnable {
        private boolean pending = false;

        LoadNotifier() {
        }

        public synchronized void setPending(boolean pending) {
            this.pending = pending;
        }

        public synchronized boolean isPending() {
            return this.pending;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LinkedList linkedList = LoadTask.this.loadQueue;
            synchronized (linkedList) {
                if (LoadTask.this.loadQueue.size() > 0) {
                    LoadItem[] items = LoadTask.this.loadQueue.toArray(new LoadItem[LoadTask.this.loadQueue.size()]);
                    LoadTask.this.loadQueue.clear();
                    LoadTask.this.loadData(items);
                }
                this.setPending(false);
            }
        }
    }

    public static final class LoadItem<E> {
        public DataTable table;
        public E data;

        public LoadItem(DataTable table, E data) {
            this.table = table;
            this.data = data;
        }
    }
}

