/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.dataset.provider;

import com.datastax.data.dataset.DataTable;
import com.datastax.data.dataset.provider.AbstractTask;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;

public abstract class SaveTask
extends AbstractTask {
    private static final Logger LOG = Logger.getLogger(SaveTask.class.getName());
    private DataTable[] tables;

    public SaveTask(DataTable[] tables) {
        this.tables = tables == null ? new DataTable[]{} : tables;
    }

    @Override
    public void run() {
        this.setIndeterminate(true);
        try {
            this.saveData(this.tables);
            this.setProgress(this.getMaximum());
        }
        catch (Exception e2) {
            Exception error = e2;
            LOG.log(Level.WARNING, "Failed to save data from tables {0}", Arrays.asList(this.tables));
            LOG.log(Level.WARNING, e2.getMessage(), e2);
            this.setProgress(this.getMaximum());
        }
    }

    protected abstract void saveData(DataTable[] var1) throws Exception;

    public String getDescription() {
        return "<html><h3>Saving data</h3></html>";
    }

    public Icon getIcon() {
        return null;
    }

    public String getMessage() {
        return "Saving item " + (this.getProgress() + 1) + " of " + this.getMaximum();
    }

    public boolean cancel() throws Exception {
        return false;
    }
}

