/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.dataset.provider.sql;

import com.datastax.data.dataset.DataCommand;
import com.datastax.data.dataset.DataRow;
import com.datastax.data.dataset.provider.sql.JDBCDataConnection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractSqlCommand
extends DataCommand {
    private static final Logger LOG = Logger.getLogger(AbstractSqlCommand.class.getName());

    protected abstract PreparedStatement getSelectStatement(JDBCDataConnection var1) throws Exception;

    protected abstract PreparedStatement getInsertStatement(JDBCDataConnection var1, DataRow var2) throws Exception;

    protected abstract PreparedStatement getUpdateStatement(JDBCDataConnection var1, DataRow var2) throws Exception;

    protected abstract PreparedStatement getDeleteStatement(JDBCDataConnection var1, DataRow var2) throws Exception;

    protected String constructSql(String sql, Map<String, List<Integer>> indexes) {
        StringBuilder buffer = new StringBuilder(sql);
        int paramIndex = 0;
        boolean inSingleQuote = false;
        boolean inDoubleQuote = false;
        for (int i2 = 0; i2 < buffer.length(); ++i2) {
            char c2 = buffer.charAt(i2);
            if (c2 == '\'') {
                inSingleQuote = !inSingleQuote;
                continue;
            }
            if (c2 == '\"') {
                inDoubleQuote = !inDoubleQuote;
                continue;
            }
            if (c2 != ':' || inSingleQuote || inDoubleQuote) continue;
            int firstCharIndex = i2++;
            boolean found = false;
            while (!found) {
                if (i2 >= buffer.length()) {
                    found = true;
                } else {
                    char next = buffer.charAt(i2);
                    if (next == ' ' || next == '\n' || next == '\t' || next == '\r' || next == ',' || next == ')') {
                        found = true;
                    }
                }
                ++i2;
            }
            String paramName = buffer.substring(firstCharIndex + 1, i2 - 1);
            buffer.replace(firstCharIndex, i2 - 1, "?");
            if (!indexes.containsKey(paramName)) {
                indexes.put(paramName, new ArrayList());
            }
            List<Integer> list = indexes.get(paramName);
            list.add(paramIndex++);
            i2 = firstCharIndex + 1;
        }
        return buffer.toString();
    }

    protected PreparedStatement prepareStatement(String sql, Map<String, Object> values, JDBCDataConnection conn) throws Exception {
        HashMap<String, List<Integer>> indexes = new HashMap<String, List<Integer>>();
        PreparedStatement ps = conn.prepareStatement(this.constructSql(sql, indexes));
        for (String paramName : this.getParameterNames()) {
            values.put(paramName, super.getParameter(paramName));
        }
        for (String paramName : this.getParameterNames(new String[]{sql})) {
            List list = (List)indexes.get(paramName);
            if (list == null) continue;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                int index = (Integer)iterator.next();
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "Index: {0}, ParamName: {1}, ParamValue: {2}", new Object[]{index + 1, paramName, values.get(paramName)});
                }
                ps.setObject(index + 1, values.get(paramName));
            }
        }
        return ps;
    }

    public String[] getParameterNames(String[] statements) {
        StringBuilder buffer = new StringBuilder();
        for (String s2 : statements) {
            buffer.append(s2);
            buffer.append("\n");
        }
        HashSet<String> names = new HashSet<String>();
        boolean inSingleQuote = false;
        boolean inDoubleQuote = false;
        for (int i2 = 0; i2 < buffer.length(); ++i2) {
            char c2 = buffer.charAt(i2);
            if (c2 == '\'') {
                inSingleQuote = !inSingleQuote;
                continue;
            }
            if (c2 == '\"') {
                inDoubleQuote = !inDoubleQuote;
                continue;
            }
            if (c2 != ':' || inSingleQuote || inDoubleQuote) continue;
            int firstCharIndex = i2++;
            boolean found = false;
            while (!found) {
                if (i2 >= buffer.length()) {
                    found = true;
                } else {
                    char next = buffer.charAt(i2);
                    if (next == ' ' || next == '\n' || next == '\t' || next == '\r' || next == ',' || next == ')') {
                        found = true;
                    }
                }
                ++i2;
            }
            String paramName = buffer.substring(firstCharIndex + 1, i2 - 1);
            names.add(paramName);
        }
        String[] results = new String[names.size()];
        return names.toArray(results);
    }
}

