/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.dataset.provider.sql;

import com.datastax.data.dataset.DataConnection;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.sql.DataSource;

public class JDBCDataConnection
extends DataConnection {
    private static final Logger LOG = Logger.getLogger(JDBCDataConnection.class.getName());
    private Connection conn;
    private final Object connMutex = new String("Connection_Mutex");
    private String jndiContext;
    private String url;
    private String userName;
    private String password;
    private Properties properties;

    public JDBCDataConnection() {
    }

    public JDBCDataConnection(String driver, String url, String user, String passwd) {
        try {
            Class.forName(driver);
        }
        catch (Exception e2) {
            LOG.log(Level.WARNING, "The driver passed to the JDBCDataConnection constructor could not be loaded. This may be due to the driver not being on the classpath", e2);
        }
        this.setUrl(url);
        this.setUserName(user);
        this.setPassword(passwd);
    }

    public JDBCDataConnection(String driver, String url, Properties props2) {
        try {
            Class.forName(driver);
        }
        catch (Exception e2) {
            LOG.log(Level.WARNING, "The driver passed to the JDBCDataConnection constructor could not be loaded. This may be due to the driver not being on the classpath", e2);
        }
        this.setUrl(url);
        this.setProperties(props2);
    }

    public JDBCDataConnection(String jndiContext, String user, String passwd) {
        this.jndiContext = jndiContext;
        this.setUserName(user);
        this.setPassword(passwd);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @Override
    protected void connect() throws Exception {
        if (this.jndiContext != null) {
            try {
                this.connectByJNDI();
            }
            catch (Exception e2) {
                try {
                    this.connectByDriverManager();
                }
                catch (Exception ex) {
                    throw new Exception("Failed to connect to the database", e2);
                }
            }
        } else {
            try {
                this.connectByDriverManager();
            }
            catch (Exception ex) {
                throw new Exception("Failed to connect to the database", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectByJNDI() throws Exception {
        InitialContext ctx = new InitialContext();
        DataSource ds = (DataSource)ctx.lookup(this.jndiContext);
        Object object = this.connMutex;
        synchronized (object) {
            try {
                this.conn = ds.getConnection();
            }
            catch (Exception e2) {
                this.conn = ds.getConnection(this.getUserName(), this.getPassword());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectByDriverManager() throws Exception {
        Object object = this.connMutex;
        synchronized (object) {
            if (this.getProperties() != null) {
                try {
                    this.conn = DriverManager.getConnection(this.getUrl(), this.getProperties());
                    this.conn.setTransactionIsolation(4);
                }
                catch (Exception e2) {
                    try {
                        this.conn = DriverManager.getConnection(this.getUrl(), this.getUserName(), this.getPassword());
                        this.conn.setTransactionIsolation(4);
                    }
                    catch (Exception ex) {
                        this.conn = DriverManager.getConnection(this.getUrl());
                        this.conn.setTransactionIsolation(4);
                    }
                }
            } else {
                try {
                    this.conn = DriverManager.getConnection(this.getUrl(), this.getUserName(), this.getPassword());
                }
                catch (Exception e3) {
                    LOG.log(Level.FINE, "Couldn't connect with the supplied user name and password. Attempting to connect annonymously.", e3);
                    this.conn = DriverManager.getConnection(this.getUrl());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void disconnect() throws Exception {
        Object object = this.connMutex;
        synchronized (object) {
            if (this.conn != null) {
                this.conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet executeQuery(PreparedStatement ps) {
        Object object = this.connMutex;
        synchronized (object) {
            if (this.conn != null) {
                try {
                    return ps.executeQuery();
                }
                catch (Exception e2) {
                    LOG.log(Level.WARNING, "Failed to execute query {0}", ps);
                    LOG.log(Level.WARNING, e2.getMessage(), e2);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(PreparedStatement ps) {
        Object object = this.connMutex;
        synchronized (object) {
            if (this.conn != null) {
                try {
                    return ps.executeUpdate();
                }
                catch (Exception e2) {
                    LOG.log(Level.WARNING, "Failed to execute update {0}", ps);
                    LOG.log(Level.WARNING, e2.getMessage(), e2);
                }
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreparedStatement prepareStatement(String sql) throws Exception {
        Object object = this.connMutex;
        synchronized (object) {
            if (this.conn != null) {
                return this.conn.prepareStatement(sql);
            }
        }
        return null;
    }

    public void commit() {
        try {
            this.conn.commit();
        }
        catch (Exception e2) {
            LOG.log(Level.WARNING, "Failed to commit", e2);
        }
    }

    public Connection getConnection() {
        return this.conn;
    }
}

