/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.dataset.provider.sql;

import com.datastax.data.dataset.DataColumn;
import com.datastax.data.dataset.DataRow;
import com.datastax.data.dataset.provider.sql.AbstractSqlCommand;
import com.datastax.data.dataset.provider.sql.JDBCDataConnection;
import java.sql.PreparedStatement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SQLCommand
extends AbstractSqlCommand {
    private static final Logger LOG = Logger.getLogger(SQLCommand.class.getName());
    private String deleteSql;
    private String insertSql;
    private String selectSql;
    private String updateSql;

    public void setSelectSQL(String sql) {
        if (this.selectSql != sql) {
            String oldValue = this.selectSql;
            this.selectSql = sql;
            this.firePropertyChange("selectSql", oldValue, sql);
        }
    }

    public String getSelectSQL() {
        return this.selectSql;
    }

    public void setUpdateSQL(String sql) {
        if (this.updateSql != sql) {
            String oldValue = this.updateSql;
            this.updateSql = sql;
            this.firePropertyChange("updateSql", oldValue, sql);
        }
    }

    public String getUpdateSQL() {
        return this.updateSql;
    }

    public void setInsertSQL(String sql) {
        if (this.insertSql != sql) {
            String oldValue = this.insertSql;
            this.insertSql = sql;
            this.firePropertyChange("insertSql", oldValue, sql);
        }
    }

    public String getInsertSQL() {
        return this.insertSql;
    }

    public void setDeleteSQL(String sql) {
        if (this.deleteSql != sql) {
            String oldValue = this.deleteSql;
            this.deleteSql = sql;
            this.firePropertyChange("deleteSql", oldValue, sql);
        }
    }

    public String getDeleteSQL() {
        return this.deleteSql;
    }

    @Override
    public String[] getParameterNames() {
        return super.getParameterNames(new String[]{this.selectSql, this.updateSql, this.insertSql, this.deleteSql});
    }

    protected PreparedStatement createPreparedStatement(String parameterizedSql, JDBCDataConnection conn) throws Exception {
        HashMap<String, List<Integer>> indexes = new HashMap<String, List<Integer>>();
        String sql = this.constructSql(parameterizedSql, indexes);
        PreparedStatement ps = conn.prepareStatement(sql);
        for (String paramName : this.getParameterNames()) {
            List list = (List)indexes.get(paramName);
            if (list == null) continue;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                int index = (Integer)iterator.next();
                ps.setObject(index + 1, this.getParameter(paramName));
            }
        }
        return ps;
    }

    @Override
    protected PreparedStatement getSelectStatement(JDBCDataConnection conn) throws Exception {
        if (this.selectSql == null) {
            throw new Exception("SQLCommand not configured with a select sql statement");
        }
        try {
            return this.createPreparedStatement(this.selectSql, conn);
        }
        catch (Exception e2) {
            LOG.log(Level.WARNING, "Problem with select SQL statement {0}", this.deleteSql);
            LOG.log(Level.WARNING, e2.getMessage(), e2);
            return null;
        }
    }

    @Override
    protected PreparedStatement getUpdateStatement(JDBCDataConnection conn, DataRow row) throws Exception {
        if (this.updateSql == null) {
            throw new Exception("SQLCommand not configured with an update sql statement");
        }
        try {
            HashMap<String, Object> values = new HashMap<String, Object>();
            List<DataColumn> columns = row.getTable().getColumns();
            for (int i2 = 0; i2 < columns.size(); ++i2) {
                DataColumn col = columns.get(i2);
                values.put(col.getName(), row.getValue(col));
            }
            int keyColCount = 0;
            for (int i3 = 0; i3 < columns.size(); ++i3) {
                DataColumn col = columns.get(i3);
                if (!col.isKeyColumn()) continue;
                values.put("orig_" + col.getName(), row.getReferenceValue(col));
                ++keyColCount;
            }
            return super.prepareStatement(this.updateSql, values, conn);
        }
        catch (Exception e2) {
            LOG.log(Level.WARNING, "Problem with update SQL statement {0}", this.deleteSql);
            LOG.log(Level.WARNING, e2.getMessage(), e2);
            return null;
        }
    }

    @Override
    protected PreparedStatement getInsertStatement(JDBCDataConnection conn, DataRow row) throws Exception {
        if (this.insertSql == null) {
            throw new Exception("SQLCommand not configured with an insert sql statement");
        }
        try {
            HashMap<String, Object> values = new HashMap<String, Object>();
            for (DataColumn col : row.getTable().getColumns()) {
                values.put(col.getName(), row.getValue(col));
            }
            return super.prepareStatement(this.insertSql, values, conn);
        }
        catch (Exception e2) {
            LOG.log(Level.WARNING, "Problem with insert SQL statement {0}", this.deleteSql);
            LOG.log(Level.WARNING, e2.getMessage(), e2);
            return null;
        }
    }

    @Override
    protected PreparedStatement getDeleteStatement(JDBCDataConnection conn, DataRow row) throws Exception {
        if (this.deleteSql == null) {
            throw new Exception("SQLCommand not configured with a delete sql statement");
        }
        try {
            HashMap<String, Object> values = new HashMap<String, Object>();
            List<DataColumn> columns = row.getTable().getColumns();
            for (int i2 = 0; i2 < columns.size(); ++i2) {
                DataColumn col = columns.get(i2);
                if (!col.isKeyColumn()) continue;
                values.put("orig_" + col.getName(), row.getReferenceValue(col));
            }
            return super.prepareStatement(this.deleteSql, values, conn);
        }
        catch (Exception e2) {
            LOG.log(Level.WARNING, "Problem with delete SQL statement {0}", this.deleteSql);
            LOG.log(Level.WARNING, e2.getMessage(), e2);
            return null;
        }
    }
}

