/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.dataset.provider.sql;

import com.datastax.data.dataset.DataColumn;
import com.datastax.data.dataset.DataProvider;
import com.datastax.data.dataset.DataRow;
import com.datastax.data.dataset.DataTable;
import com.datastax.data.dataset.event.TableChangeEvent;
import com.datastax.data.dataset.provider.LoadTask;
import com.datastax.data.dataset.provider.SaveTask;
import com.datastax.data.dataset.provider.sql.AbstractSqlCommand;
import com.datastax.data.dataset.provider.sql.JDBCDataConnection;
import com.datastax.data.dataset.provider.sql.TableCommand;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SQLDataProvider
extends DataProvider {
    private static final Logger LOG = Logger.getLogger(SQLDataProvider.class.getName());
    private Map<String, String> columnMappings = new HashMap<String, String>();

    public SQLDataProvider() {
    }

    public SQLDataProvider(String tableName) {
        TableCommand tableCommand = new TableCommand(tableName);
        this.setCommand(tableCommand);
    }

    public SQLDataProvider(String tableName, String whereClause) {
        TableCommand tableCommand = new TableCommand(tableName, whereClause);
        this.setCommand(tableCommand);
    }

    public void addColumnNameMapping(String pseudonym, String realName) {
        this.columnMappings.put(pseudonym, realName);
    }

    public void removeColumnNameMapping(String pseudonym) {
        this.columnMappings.remove(pseudonym);
    }

    @Override
    protected LoadTask createLoadTask(DataTable[] tables) {
        return new LoadTask(tables){

            @Override
            protected void readData(DataTable[] tables) throws Exception {
                JDBCDataConnection conn = (JDBCDataConnection)SQLDataProvider.this.getConnection();
                if (conn == null) {
                    return;
                }
                if (SQLDataProvider.this.getCommand() == null) {
                    return;
                }
                this.setMinimum(0);
                this.setMaximum(tables.length);
                for (DataTable table : tables) {
                    try {
                        PreparedStatement stmt = ((AbstractSqlCommand)SQLDataProvider.this.getCommand()).getSelectStatement(conn);
                        ResultSet rs = stmt.executeQuery();
                        HashSet<Object> colNames = new HashSet<Object>();
                        colNames.addAll(SQLDataProvider.this.columnMappings.keySet());
                        for (DataColumn col : table.getColumns()) {
                            colNames.add(col.getName());
                        }
                        ResultSetMetaData md = rs.getMetaData();
                        ArrayList<String> names = new ArrayList<String>();
                        for (String string : colNames) {
                            for (int i2 = 0; i2 < md.getColumnCount(); ++i2) {
                                if (!string.equalsIgnoreCase(md.getColumnName(i2 + 1))) continue;
                                names.add(string);
                            }
                        }
                        ArrayList rows = new ArrayList(60);
                        while (rs.next()) {
                            if (rows.size() >= 50) {
                                LoadTask.LoadItem loadItem = new LoadTask.LoadItem(table, rows);
                                this.scheduleLoad(loadItem);
                                rows = new ArrayList(60);
                            }
                            HashMap<String, Object> hashMap = new HashMap<String, Object>();
                            for (String name : names) {
                                hashMap.put(name, rs.getObject(name));
                            }
                            rows.add(hashMap);
                        }
                        rs.close();
                        LoadTask.LoadItem loadItem = new LoadTask.LoadItem(table, rows);
                        this.scheduleLoad(loadItem);
                    }
                    catch (Exception e2) {
                        LOG.log(Level.WARNING, "Failed to read data for table {0}", table);
                        LOG.log(Level.WARNING, e2.getMessage(), e2);
                    }
                    this.setProgress(this.getProgress() + 1);
                }
                this.setProgress(this.getMaximum());
            }

            @Override
            protected void loadData(LoadTask.LoadItem[] items) {
                for (LoadTask.LoadItem item : items) {
                    for (Map row : (List)item.data) {
                        DataRow r2 = item.table.appendRowNoEvent();
                        for (String col : row.keySet()) {
                            if (SQLDataProvider.this.columnMappings.containsKey(col)) {
                                col = (String)SQLDataProvider.this.columnMappings.get(col);
                            }
                            r2.setValue(col, row.get(col));
                        }
                        r2.setStatus(DataRow.DataRowStatus.UNCHANGED);
                        item.table.fireDataTableChanged(TableChangeEvent.newRowAddedEvent(item.table, r2));
                    }
                    item.table.fireDataTableChanged(TableChangeEvent.newLoadCompleteEvent(item.table));
                }
            }
        };
    }

    @Override
    protected SaveTask createSaveTask(DataTable[] tables) {
        return new SaveTask(tables){

            @Override
            protected void saveData(DataTable[] tables) throws Exception {
                JDBCDataConnection conn = (JDBCDataConnection)SQLDataProvider.this.getConnection();
                if (conn == null) {
                    return;
                }
                if (SQLDataProvider.this.getCommand() == null) {
                    return;
                }
                this.setMinimum(0);
                this.setMaximum(tables.length);
                for (DataTable table : tables) {
                    ArrayList<DataRow> rows = new ArrayList<DataRow>(table.getRows());
                    for (DataRow row : rows) {
                        PreparedStatement stmt = null;
                        switch (row.getStatus()) {
                            case UPDATED: {
                                stmt = ((AbstractSqlCommand)SQLDataProvider.this.getCommand()).getUpdateStatement(conn, row);
                                conn.executeUpdate(stmt);
                                row.setStatus(DataRow.DataRowStatus.UNCHANGED);
                                break;
                            }
                            case INSERTED: {
                                stmt = ((AbstractSqlCommand)SQLDataProvider.this.getCommand()).getInsertStatement(conn, row);
                                conn.executeUpdate(stmt);
                                row.setStatus(DataRow.DataRowStatus.UNCHANGED);
                                break;
                            }
                            case DELETED: {
                                stmt = ((AbstractSqlCommand)SQLDataProvider.this.getCommand()).getDeleteStatement(conn, row);
                                conn.executeUpdate(stmt);
                                table.discardRow(row);
                                break;
                            }
                        }
                    }
                    table.fireDataTableChanged(TableChangeEvent.newSaveCompleteEvent(table));
                    this.setProgress(this.getProgress() + 1);
                }
                this.setProgress(this.getMaximum());
                conn.commit();
            }
        };
    }
}

