/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.dataset.provider.sql;

import com.datastax.data.dataset.DataColumn;
import com.datastax.data.dataset.DataRow;
import com.datastax.data.dataset.provider.sql.JDBCDataConnection;
import com.datastax.data.dataset.provider.sql.SQLCommand;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TableCommand
extends SQLCommand {
    private static final Logger LOG = Logger.getLogger(TableCommand.class.getName());
    private String tableName;
    private String whereClause = "";
    private String orderByClause = "";
    private String havingClause = "";

    public TableCommand() {
        this(null, null);
    }

    public TableCommand(String tableName) {
        this(tableName, null);
    }

    public TableCommand(String tableName, String whereClause) {
        this.setTableName(tableName);
        this.setWhereClause(whereClause);
    }

    public void setTableName(String tableName) {
        if (this.tableName != tableName) {
            String oldValue = this.tableName;
            this.tableName = tableName;
            this.firePropertyChange("tableName", oldValue, tableName);
        }
    }

    public void setWhereClause(String clause) {
        if (this.whereClause != clause) {
            String oldValue = this.whereClause;
            this.whereClause = clause == null ? "" : clause;
            this.firePropertyChange("whereClause", oldValue, this.whereClause);
        }
    }

    public void setOrderByClause(String clause) {
        if (this.orderByClause != clause) {
            String oldValue = this.orderByClause;
            this.orderByClause = clause == null ? "" : clause;
            this.firePropertyChange("orderByClause", oldValue, this.orderByClause);
        }
    }

    public void setHavingClause(String clause) {
        if (this.havingClause != clause) {
            String oldValue = this.havingClause;
            this.havingClause = clause == null ? "" : clause;
            this.firePropertyChange("havingClause", oldValue, this.havingClause);
        }
    }

    @Override
    public String[] getParameterNames() {
        ArrayList<String> strings = new ArrayList<String>();
        if (this.getSelectSQL() != null) {
            strings.add(this.getSelectSQL());
        } else {
            strings.add(this.whereClause);
            strings.add(this.orderByClause);
            strings.add(this.havingClause);
        }
        if (this.getUpdateSQL() != null) {
            strings.add(this.getUpdateSQL());
        }
        if (this.getDeleteSQL() != null) {
            strings.add(this.getDeleteSQL());
        }
        if (this.getInsertSQL() != null) {
            strings.add(this.getInsertSQL());
        }
        return super.getParameterNames(strings.toArray(new String[strings.size()]));
    }

    @Override
    protected PreparedStatement getSelectStatement(JDBCDataConnection conn) throws Exception {
        if (this.tableName == null) {
            throw new Exception("TableCommand not configured with a table name");
        }
        if (super.getSelectSQL() != null) {
            return super.getSelectStatement(conn);
        }
        String sql = "";
        try {
            StringBuilder buffer = new StringBuilder();
            buffer.append("select * from ");
            buffer.append("\"").append(this.tableName).append("\"");
            buffer.append(" ");
            buffer.append(this.whereClause);
            buffer.append(" ");
            buffer.append(this.orderByClause);
            buffer.append(" ");
            buffer.append(this.havingClause);
            sql = buffer.toString().trim();
            LOG.log(Level.FINE, "Generated Select SQL: " + sql);
            return this.createPreparedStatement(sql, conn);
        }
        catch (Exception e2) {
            LOG.log(Level.WARNING, "Problem with creating select SQL statement {0}", sql);
            LOG.log(Level.WARNING, e2.getMessage(), e2);
            return null;
        }
    }

    @Override
    protected PreparedStatement getUpdateStatement(JDBCDataConnection conn, DataRow row) throws Exception {
        if (this.tableName == null) {
            throw new Exception("TableCommand not configured with a table name");
        }
        if (super.getUpdateSQL() != null) {
            return super.getUpdateStatement(conn, row);
        }
        String sql = "";
        try {
            HashMap<String, Object> values = new HashMap<String, Object>();
            StringBuilder buffer = new StringBuilder();
            buffer.append("update ");
            buffer.append("\"").append(this.tableName).append("\"");
            buffer.append(" set ");
            List<DataColumn> columns = this.getUpdateableColumns(row.getTable().getColumns());
            int modCount = 0;
            for (int i2 = 0; i2 < columns.size(); ++i2) {
                DataColumn col = columns.get(i2);
                if (!row.isModified(col)) continue;
                buffer.append("\"").append(col.getName()).append("\"");
                buffer.append(" = :" + col.getName() + ", ");
                values.put(col.getName(), row.getValue(col));
                ++modCount;
            }
            if (modCount == 0) {
                return null;
            }
            buffer.delete(buffer.length() - 2, buffer.length());
            buffer.append(" where ");
            int keyColCount = 0;
            for (int i3 = 0; i3 < columns.size(); ++i3) {
                DataColumn col = columns.get(i3);
                if (!col.isKeyColumn()) continue;
                buffer.append("\"").append(col.getName()).append("\"");
                buffer.append(" = :orig_" + col.getName() + " and ");
                values.put("orig_" + col.getName(), row.getReferenceValue(col));
                ++keyColCount;
            }
            if (keyColCount == 0) {
                LOG.log(Level.WARNING, "!!! No key columns were specified, the entire table '{0}' will be updated!!", this.tableName);
                buffer.delete(buffer.length() - 7, buffer.length());
            } else {
                buffer.delete(buffer.length() - 4, buffer.length());
            }
            sql = buffer.toString().trim();
            LOG.log(Level.FINE, "Generated Update SQL: " + sql);
            return super.prepareStatement(sql, values, conn);
        }
        catch (Exception e2) {
            LOG.log(Level.WARNING, "Problem with creating update SQL statement {0}", sql);
            LOG.log(Level.WARNING, e2.getMessage(), e2);
            return null;
        }
    }

    @Override
    protected PreparedStatement getInsertStatement(JDBCDataConnection conn, DataRow row) throws Exception {
        if (this.tableName == null) {
            throw new Exception("TableCommand not configured with a table name");
        }
        if (super.getInsertSQL() != null) {
            return super.getInsertStatement(conn, row);
        }
        String sql = "";
        try {
            HashMap<String, Object> values = new HashMap<String, Object>();
            StringBuilder buffer = new StringBuilder();
            buffer.append("insert into ");
            buffer.append("\"").append(this.tableName).append("\"");
            buffer.append("(");
            List<DataColumn> cols = this.getUpdateableColumns(row.getTable().getColumns());
            for (DataColumn col : cols) {
                buffer.append("\"").append(col.getName()).append("\"");
                buffer.append(", ");
            }
            buffer.replace(buffer.length() - 2, buffer.length(), ")");
            buffer.append(" values(");
            for (DataColumn col : cols) {
                buffer.append(":" + col.getName() + ", ");
                values.put(col.getName(), row.getValue(col));
            }
            buffer.replace(buffer.length() - 2, buffer.length(), ")");
            sql = buffer.toString().trim();
            LOG.log(Level.FINE, "Generated Insert SQL: " + sql);
            return super.prepareStatement(sql, values, conn);
        }
        catch (Exception e2) {
            LOG.log(Level.WARNING, "Problem with creating insert SQL statement {0}", sql);
            LOG.log(Level.WARNING, e2.getMessage(), e2);
            return null;
        }
    }

    @Override
    protected PreparedStatement getDeleteStatement(JDBCDataConnection conn, DataRow row) throws Exception {
        if (this.tableName == null) {
            throw new Exception("TableCommand not configured with a table name");
        }
        if (super.getDeleteSQL() != null) {
            return super.getDeleteStatement(conn, row);
        }
        String sql = "";
        try {
            HashMap<String, Object> values = new HashMap<String, Object>();
            StringBuilder buffer = new StringBuilder();
            buffer.append("delete from ");
            buffer.append("\"").append(this.tableName).append("\"");
            buffer.append(" where ");
            int keyColCount = 0;
            List<DataColumn> columns = row.getTable().getColumns();
            for (int i2 = 0; i2 < columns.size(); ++i2) {
                DataColumn col = columns.get(i2);
                if (!col.isKeyColumn()) continue;
                buffer.append("\"").append(col.getName()).append("\"");
                buffer.append(" = :orig_" + col.getName() + " and ");
                values.put("orig_" + col.getName(), row.getReferenceValue(col));
                ++keyColCount;
            }
            if (keyColCount == 0) {
                LOG.log(Level.WARNING, "!!! No key columns were specified, the entire table '" + this.tableName + "' will be deleted!!");
                buffer.delete(buffer.length() - 7, buffer.length());
            } else {
                buffer.delete(buffer.length() - 4, buffer.length());
            }
            sql = buffer.toString().trim();
            LOG.log(Level.FINE, "Generated Delete SQL: " + sql);
            return super.prepareStatement(sql, values, conn);
        }
        catch (Exception e2) {
            LOG.log(Level.WARNING, "Problem with creating delete SQL statement {0}", sql);
            LOG.log(Level.WARNING, e2.getMessage(), e2);
            return null;
        }
    }

    private List<DataColumn> getUpdateableColumns(List<DataColumn> cols) {
        ArrayList<DataColumn> results = new ArrayList<DataColumn>();
        for (DataColumn col : cols) {
            if (col.getExpression() != null && !col.getExpression().equals("")) continue;
            results.add(col);
        }
        return results;
    }
}

