/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.dataset.provider.sql;

import com.datastax.data.dataset.DataColumn;
import com.datastax.data.dataset.DataProvider;
import com.datastax.data.dataset.DataRow;
import com.datastax.data.dataset.DataTable;
import com.datastax.data.dataset.event.TableChangeEvent;
import com.datastax.data.dataset.provider.LoadTask;
import com.datastax.data.dataset.provider.SaveTask;
import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.RowSetMetaData;
import javax.sql.rowset.RowSetMetaDataImpl;
import javax.swing.SwingUtilities;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class WebRowSetDataProvider
extends DataProvider {
    private static final Logger LOG = Logger.getLogger(WebRowSetDataProvider.class.getName());
    private static final SAXParserFactory FACTORY = SAXParserFactory.newInstance();
    private URL url;
    private Runnable completionRunnable;
    private Runnable metadataCompleteRunnable;

    @Override
    protected SaveTask createSaveTask(DataTable[] tables) {
        return new SaveTask(tables){

            @Override
            protected void saveData(DataTable[] tables) throws Exception {
            }
        };
    }

    @Override
    protected LoadTask createLoadTask(DataTable[] tables) {
        return new LoadTask(tables){

            @Override
            protected void loadData(LoadTask.LoadItem[] items) {
                for (LoadTask.LoadItem item : items) {
                    DataTable table = item.table;
                    List loadItems = (List)item.data;
                    for (RowLoadItem loadItem : loadItems) {
                        DataRow row = table.appendRowNoEvent();
                        List<DataColumn> cols = table.getColumns();
                        for (int i2 = 0; i2 < loadItem.values.length; ++i2) {
                            try {
                                row.setValue(cols.get(i2).getName(), loadItem.values[i2]);
                                continue;
                            }
                            catch (Exception e2) {
                                LOG.log(Level.FINE, "{0}", loadItem.values.length);
                            }
                        }
                        row.setStatus(loadItem.status);
                        item.table.fireDataTableChanged(TableChangeEvent.newRowAddedEvent(item.table, row));
                    }
                    item.table.fireDataTableChanged(TableChangeEvent.newLoadCompleteEvent(item.table));
                }
            }

            @Override
            protected void readData(DataTable[] tables) throws Exception {
                try {
                    for (int i2 = 0; i2 < tables.length; ++i2) {
                        InputStream is = WebRowSetDataProvider.this.url.openStream();
                        this.readXml(new InputStreamReader(is), tables[i2]);
                    }
                }
                catch (Exception e2) {
                    LOG.log(Level.WARNING, "Error", e2);
                }
            }

            public void doLoad(DataTable table, List items) {
                super.scheduleLoad(new LoadTask.LoadItem<List>(table, items));
            }

            public void readXml(Reader reader, DataTable table) throws SQLException {
                try {
                    WebRowSetXMLHandler handler = new WebRowSetXMLHandler(table);
                    SAXParser parser = FACTORY.newSAXParser();
                    XMLReader xmlReader = parser.getXMLReader();
                    xmlReader.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
                    parser.parse(new InputSource(reader), (DefaultHandler)handler);
                }
                catch (Exception e2) {
                    LOG.log(Level.WARNING, "Error", e2);
                    throw new SQLException("Error while parsing a the xml document for a WebRowSetDataProvider");
                }
            }

            class WebRowSetXMLHandler
            extends DefaultHandler
            implements LexicalHandler {
                DataTable table;
                private List dataToLoad = new LinkedList();
                private Stack<String> tagStack = new Stack();
                private boolean inProperties = false;
                private boolean inMetaData = false;
                private boolean inData = false;
                private RowSetMetaData metaData = null;
                private int columnIndex = 1;
                private Stack<Integer> keyColumnsStack = new Stack();
                private String mapType;
                private String mapClass;
                private Map<String, Class<?>> typeMap = new HashMap();
                private String data;
                private boolean wasNull;
                private String tableName = "";
                private Object[] rowValues;
                private int currentRow = 0;

                public WebRowSetXMLHandler(DataTable table) {
                    this.table = table;
                }

                @Override
                public void comment(char[] ch, int start2, int length) throws SAXException {
                }

                @Override
                public void startCDATA() throws SAXException {
                }

                @Override
                public void endCDATA() throws SAXException {
                }

                @Override
                public void startEntity(String name) throws SAXException {
                }

                @Override
                public void endEntity(String name) throws SAXException {
                }

                @Override
                public void startDTD(String name, String publicId, String systemId) throws SAXException {
                }

                @Override
                public void endDTD() throws SAXException {
                }

                @Override
                public void characters(char[] ch, int start2, int length) throws SAXException {
                    this.data = this.data == null ? new String(ch, start2, length) : this.data + new String(ch, start2, length);
                    this.data = this.data.trim();
                }

                private void setValue(int columnIndex, String value) throws Exception {
                    if (this.wasNull || value == null) {
                        this.rowValues[columnIndex - 1] = null;
                    } else {
                        switch (this.metaData.getColumnType(columnIndex)) {
                            case -6: {
                                this.rowValues[columnIndex - 1] = Byte.valueOf(value.trim());
                                break;
                            }
                            case 5: {
                                this.rowValues[columnIndex - 1] = Short.valueOf(value.trim());
                                break;
                            }
                            case 4: {
                                this.rowValues[columnIndex - 1] = Integer.valueOf(value.trim());
                                break;
                            }
                            case -5: {
                                this.rowValues[columnIndex - 1] = Long.valueOf(value.trim());
                                break;
                            }
                            case 7: {
                                this.rowValues[columnIndex - 1] = Float.valueOf(value.trim());
                                break;
                            }
                            case 6: 
                            case 8: {
                                this.rowValues[columnIndex - 1] = Double.valueOf(value.trim());
                                break;
                            }
                            case 2: 
                            case 3: {
                                this.rowValues[columnIndex - 1] = new BigDecimal(value.trim());
                                break;
                            }
                            case -7: 
                            case 16: {
                                this.rowValues[columnIndex - 1] = Boolean.valueOf(value.trim());
                                break;
                            }
                            case -1: 
                            case 1: 
                            case 12: {
                                this.rowValues[columnIndex - 1] = value;
                                break;
                            }
                            case -4: 
                            case -3: 
                            case -2: {
                                byte[] bytes = Base64.decode(value);
                                this.rowValues[columnIndex - 1] = bytes;
                                break;
                            }
                            case 91: 
                            case 92: 
                            case 93: {
                                this.rowValues[columnIndex - 1] = new Timestamp(Long.parseLong(value.trim()));
                                break;
                            }
                            case 70: 
                            case 1111: 
                            case 2000: 
                            case 2001: 
                            case 2002: 
                            case 2003: 
                            case 2004: 
                            case 2005: 
                            case 2006: {
                                break;
                            }
                        }
                    }
                }

                @Override
                public void endDocument() throws SAXException {
                    this.doLoad(this.table, this.dataToLoad);
                    if (WebRowSetDataProvider.this.completionRunnable != null) {
                        SwingUtilities.invokeLater(WebRowSetDataProvider.this.completionRunnable);
                    }
                }

                @Override
                public void endElement(String uri, String localName, String qName) throws SAXException {
                    if (this.tagStack.size() == 0) {
                        return;
                    }
                    String tag = this.tagStack.pop();
                    try {
                        if (tag.equals("null")) {
                            this.wasNull = true;
                        } else if (tag.equals("columnvalue")) {
                            this.setValue(this.columnIndex++, this.wasNull ? null : this.data);
                        } else if (tag.equals("updatevalue")) {
                            this.setValue(this.columnIndex - 1, this.wasNull ? null : this.data);
                        } else if (tag.equals("currentrow")) {
                            RowLoadItem loadItem = new RowLoadItem();
                            loadItem.values = new Object[this.rowValues.length];
                            System.arraycopy(this.rowValues, 0, loadItem.values, 0, this.rowValues.length);
                            loadItem.status = DataRow.DataRowStatus.UNCHANGED;
                            this.dataToLoad.add(loadItem);
                        } else if (tag.equals("insertrow")) {
                            RowLoadItem loadItem = new RowLoadItem();
                            loadItem.values = new Object[this.rowValues.length];
                            System.arraycopy(this.rowValues, 0, loadItem.values, 0, this.rowValues.length);
                            loadItem.status = DataRow.DataRowStatus.INSERTED;
                        } else if (tag.equals("deleterow")) {
                            RowLoadItem loadItem = new RowLoadItem();
                            loadItem.values = new Object[this.rowValues.length];
                            System.arraycopy(this.rowValues, 0, loadItem.values, 0, this.rowValues.length);
                            loadItem.status = DataRow.DataRowStatus.DELETED;
                        } else if (tag.equals("modifyrow")) {
                            RowLoadItem loadItem = new RowLoadItem();
                            loadItem.values = new Object[this.rowValues.length];
                            System.arraycopy(this.rowValues, 0, loadItem.values, 0, this.rowValues.length);
                            loadItem.status = DataRow.DataRowStatus.UPDATED;
                        } else if (tag.equals("column")) {
                            if (!this.wasNull) {
                                this.keyColumnsStack.push(new Integer(this.data.trim()));
                            }
                        } else if (tag.equals("type")) {
                            this.mapType = this.wasNull ? null : this.data;
                        } else if (tag.equals("class")) {
                            this.mapClass = this.wasNull ? null : this.data;
                            this.typeMap.put(this.mapType, this.mapClass == null ? null : Class.forName(this.mapClass));
                        } else if (tag.equals("table-name")) {
                            if (!this.inProperties && this.inMetaData) {
                                this.metaData.setTableName(this.columnIndex, this.wasNull ? null : this.data);
                            }
                        } else if (tag.equals("column-count")) {
                            this.metaData.setColumnCount(this.wasNull ? 0 : Integer.parseInt(this.data.trim()));
                        } else if (tag.equals("column-index")) {
                            this.columnIndex = Integer.parseInt(this.data.trim());
                        } else if (tag.equals("key-columns")) {
                            int[] kc = new int[this.keyColumnsStack.size()];
                            int i2 = 0;
                            for (Integer col : this.keyColumnsStack) {
                                kc[i2++] = col;
                            }
                        } else if (!tag.equals("map")) {
                            if (tag.equals("auto-increment")) {
                                this.metaData.setAutoIncrement(this.columnIndex, this.wasNull ? false : Boolean.parseBoolean(this.data));
                            } else if (tag.equals("case-sensitive")) {
                                this.metaData.setCaseSensitive(this.columnIndex, this.wasNull ? false : Boolean.parseBoolean(this.data));
                            } else if (tag.equals("currency")) {
                                this.metaData.setCurrency(this.columnIndex, this.wasNull ? false : Boolean.parseBoolean(this.data.trim()));
                            } else if (tag.equals("nullable")) {
                                this.metaData.setNullable(this.columnIndex, this.wasNull ? 0 : Integer.parseInt(this.data.trim()));
                            } else if (tag.equals("signed")) {
                                this.metaData.setSigned(this.columnIndex, this.wasNull ? false : Boolean.parseBoolean(this.data.trim()));
                            } else if (tag.equals("searchable")) {
                                this.metaData.setSearchable(this.columnIndex, this.wasNull ? false : Boolean.parseBoolean(this.data.trim()));
                            } else if (tag.equals("column-display-size")) {
                                this.metaData.setColumnDisplaySize(this.columnIndex, this.wasNull ? 255 : Integer.parseInt(this.data.trim()));
                            } else if (tag.equals("column-label")) {
                                this.metaData.setColumnLabel(this.columnIndex, this.wasNull ? null : this.data);
                            } else if (tag.equals("column-name")) {
                                this.metaData.setColumnName(this.columnIndex, this.data);
                            } else if (tag.equals("schema-name")) {
                                this.metaData.setSchemaName(this.columnIndex, this.wasNull ? null : this.data);
                            } else if (tag.equals("column-precision")) {
                                this.metaData.setPrecision(this.columnIndex, this.wasNull ? 0 : Integer.parseInt(this.data.trim()));
                            } else if (tag.equals("column-scale")) {
                                this.metaData.setScale(this.columnIndex, this.wasNull ? 0 : Integer.parseInt(this.data.trim()));
                            } else if (tag.equals("catalog-name")) {
                                this.metaData.setCatalogName(this.columnIndex, this.wasNull ? null : this.data);
                            } else if (tag.equals("column-type")) {
                                this.metaData.setColumnType(this.columnIndex, this.wasNull ? 12 : Integer.parseInt(this.data.trim()));
                            } else if (tag.equals("column-type-name")) {
                                this.metaData.setColumnTypeName(this.columnIndex, this.wasNull ? null : this.data);
                            } else if (tag.equals("metadata")) {
                                SwingUtilities.invokeAndWait(new Runnable(){

                                    @Override
                                    public void run() {
                                        DataColumn[] cols;
                                        WebRowSetXMLHandler.this.table.clear();
                                        for (DataColumn col : cols = WebRowSetXMLHandler.this.table.getColumns().toArray(new DataColumn[WebRowSetXMLHandler.this.table.getColumns().size()])) {
                                            WebRowSetXMLHandler.this.table.dropColumn(col.getName());
                                        }
                                        try {
                                            block17: for (int i2 = 0; i2 < WebRowSetXMLHandler.this.metaData.getColumnCount(); ++i2) {
                                                DataColumn col = WebRowSetXMLHandler.this.table.createColumn(WebRowSetXMLHandler.this.metaData.getColumnName(i2 + 1));
                                                switch (WebRowSetXMLHandler.this.metaData.getColumnType(i2 + 1)) {
                                                    case -6: {
                                                        col.setType(Byte.class);
                                                        continue block17;
                                                    }
                                                    case 5: {
                                                        col.setType(Short.class);
                                                        continue block17;
                                                    }
                                                    case 4: {
                                                        col.setType(Integer.class);
                                                        continue block17;
                                                    }
                                                    case -5: {
                                                        col.setType(BigInteger.class);
                                                        continue block17;
                                                    }
                                                    case 7: {
                                                        col.setType(Float.class);
                                                        continue block17;
                                                    }
                                                    case 6: 
                                                    case 8: {
                                                        col.setType(Double.class);
                                                        continue block17;
                                                    }
                                                    case 2: 
                                                    case 3: {
                                                        col.setType(BigDecimal.class);
                                                        continue block17;
                                                    }
                                                    case -7: 
                                                    case 16: {
                                                        col.setType(Boolean.class);
                                                        continue block17;
                                                    }
                                                    case -1: 
                                                    case 1: 
                                                    case 12: {
                                                        col.setType(String.class);
                                                        continue block17;
                                                    }
                                                    case -4: 
                                                    case -3: 
                                                    case -2: {
                                                        col.setType(Byte[].class);
                                                        continue block17;
                                                    }
                                                    case 91: 
                                                    case 92: 
                                                    case 93: {
                                                        col.setType(Timestamp.class);
                                                        continue block17;
                                                    }
                                                    case 70: 
                                                    case 1111: 
                                                    case 2000: 
                                                    case 2001: 
                                                    case 2002: 
                                                    case 2003: 
                                                    case 2004: 
                                                    case 2005: 
                                                    case 2006: {
                                                        continue block17;
                                                    }
                                                }
                                            }
                                        }
                                        catch (Exception e2) {
                                            LOG.log(Level.WARNING, "Error", e2);
                                        }
                                    }
                                });
                                if (WebRowSetDataProvider.this.metadataCompleteRunnable != null) {
                                    SwingUtilities.invokeLater(WebRowSetDataProvider.this.metadataCompleteRunnable);
                                }
                            }
                        }
                    }
                    catch (Exception e2) {
                        LOG.log(Level.WARNING, "Error", e2);
                    }
                    this.data = null;
                    if (this.dataToLoad.size() >= 100) {
                        this.doLoad(this.table, this.dataToLoad);
                        this.dataToLoad = new LinkedList();
                    }
                }

                @Override
                public void startDocument() throws SAXException {
                }

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    this.wasNull = false;
                    String tag = qName.toLowerCase();
                    this.tagStack.push(tag);
                    try {
                        if (tag.equals("properties")) {
                            this.inProperties = true;
                            this.inMetaData = false;
                            this.inData = false;
                        } else if (tag.equals("metadata")) {
                            this.inProperties = false;
                            this.inMetaData = true;
                            this.inData = false;
                            this.metaData = new RowSetMetaDataImpl();
                        } else if (tag.equals("data")) {
                            this.inProperties = false;
                            this.inMetaData = false;
                            this.inData = true;
                            this.rowValues = new Object[this.metaData.getColumnCount()];
                        } else if (tag.equals("currentrow")) {
                            this.columnIndex = 1;
                            this.reinitRowValues();
                            ++this.currentRow;
                        } else if (tag.equals("insertrow")) {
                            this.columnIndex = 1;
                            this.reinitRowValues();
                            ++this.currentRow;
                        } else if (tag.equals("deleterow")) {
                            this.columnIndex = 1;
                            this.reinitRowValues();
                            ++this.currentRow;
                        } else if (tag.equals("modifyrow")) {
                            this.columnIndex = 1;
                            this.reinitRowValues();
                            ++this.currentRow;
                        }
                    }
                    catch (Exception e2) {
                        LOG.log(Level.WARNING, "Error", e2);
                    }
                }

                private void reinitRowValues() {
                    for (int i2 = 0; i2 < this.rowValues.length; ++i2) {
                        this.rowValues[i2] = null;
                    }
                }
            }
        };
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public Runnable getCompletionRunnable() {
        return this.completionRunnable;
    }

    public void setCompletionRunnable(Runnable completionRunnable) {
        this.completionRunnable = completionRunnable;
    }

    public Runnable getMetadataCompleteRunnable() {
        return this.metadataCompleteRunnable;
    }

    public void setMetadataCompleteRunnable(Runnable metadataCompleteRunnable) {
        this.metadataCompleteRunnable = metadataCompleteRunnable;
    }

    static {
        FACTORY.setValidating(false);
    }

    final class RowLoadItem {
        public Object[] values;
        public DataRow.DataRowStatus status;

        RowLoadItem() {
        }
    }
}

