/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.exploration.biz.datatable;

import com.datastax.data.exploration.biz.datatable.DataType;
import com.datastax.data.exploration.biz.datatable.column.BinomialColumn;
import com.datastax.data.exploration.biz.datatable.column.DataColumn;
import com.datastax.data.exploration.biz.datatable.column.DateColumn;
import com.datastax.data.exploration.biz.datatable.column.DateTimeColumn;
import com.datastax.data.exploration.biz.datatable.column.DecimalColumn;
import com.datastax.data.exploration.biz.datatable.column.IntegerColumn;
import com.datastax.data.exploration.biz.datatable.column.PolynomialColumn;
import com.datastax.data.exploration.biz.datatable.column.TextColumn;
import com.datastax.data.exploration.biz.datatable.column.TimeColumn;
import java.util.ArrayList;

public class DataColumnCollection
extends ArrayList<DataColumn> {
    @Override
    public boolean add(DataColumn column) {
        return super.add(column);
    }

    public boolean add(String columnName, DataType type) {
        DataColumn column;
        switch (type) {
            case BINOMIAL: {
                column = new BinomialColumn(columnName);
                break;
            }
            case POLYNOMIAL: {
                column = new PolynomialColumn(columnName);
                break;
            }
            case DECIMAL: {
                column = new DecimalColumn(columnName);
                break;
            }
            case INT: {
                column = new IntegerColumn(columnName);
                break;
            }
            case DATE_TIME: {
                column = new DateTimeColumn(columnName);
                break;
            }
            case DATE: {
                column = new DateColumn(columnName);
                break;
            }
            case TIME: {
                column = new TimeColumn(columnName);
                break;
            }
            default: {
                column = new TextColumn(columnName);
            }
        }
        return this.add(column);
    }

    public DataColumn getColumn(String name) {
        if (name == null) {
            return null;
        }
        for (Object c2 : super.toArray()) {
            DataColumn column = (DataColumn)c2;
            if (!column.getColumnName().equals(name)) continue;
            return column;
        }
        return null;
    }

    public boolean contains(String columnName) {
        for (Object c2 : super.toArray()) {
            DataColumn column = (DataColumn)c2;
            if (!column.getColumnName().equals(columnName)) continue;
            return true;
        }
        return false;
    }

    DataColumn getColumn(int i2) throws Exception {
        DataColumn column;
        try {
            column = (DataColumn)super.get(i2);
        }
        catch (Exception x2) {
            throw new Exception("\u6b64\u7d22\u5f15\u5904\u4e0d\u5b58\u5728\u5217");
        }
        return column;
    }

    private void remove(DataColumn value) {
        super.remove(value);
    }

    public void remove(String columnName) {
        for (Object c2 : super.toArray()) {
            DataColumn column = (DataColumn)c2;
            if (!column.getColumnName().equals(columnName)) continue;
            this.remove(column);
            break;
        }
    }
}

