/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.exploration.biz.datatable;

import com.datastax.data.exploration.biz.datatable.DataRow;
import com.datastax.data.exploration.biz.datatable.DataTable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataRowCollection
extends ArrayList<DataRow> {
    private DataTable table;

    DataRowCollection(DataTable table) {
        this.table = table;
    }

    public DataRow add(String[] values) throws Exception {
        int count = this.table.getColumns().size();
        if (count < values.length) {
            throw new Exception("\u8f93\u5165\u6570\u7ec4\u957f\u5ea6\u5927\u4e8e\u6b64\u8868\u4e2d\u7684\u5217\u6570\u3002");
        }
        for (int i2 = 0; i2 < values.length; ++i2) {
            if (values[i2] != null) {
                this.table.getColumns().getColumn(i2).setData(this.size(), values[i2]);
                continue;
            }
            this.table.getColumns().getColumn(i2).setData(this.size(), null);
        }
        for (int j2 = values.length; j2 < count; ++j2) {
            this.table.getColumns().getColumn(j2).setData(this.size(), null);
        }
        DataRow row = new DataRow(this.table, this.size());
        super.add(row);
        return row;
    }

    public DataRow getRow(int i2) throws Exception {
        DataRow datarow;
        try {
            datarow = (DataRow)super.get(i2);
        }
        catch (Exception x2) {
            throw new Exception("\u6b64\u7d22\u5f15\u5904\u4e0d\u5b58\u5728\u5217");
        }
        return datarow;
    }

    public Map<Object, List<DataRow>> aggList(String groupColumnName) {
        HashMap<Object, List<DataRow>> map = new HashMap<Object, List<DataRow>>();
        for (Object o2 : super.toArray()) {
            DataRow row = (DataRow)o2;
            Object key = row.getValue(groupColumnName);
            if (key == null || row == null) continue;
            ArrayList<DataRow> list = (ArrayList<DataRow>)map.get(key);
            if (list == null) {
                list = new ArrayList<DataRow>();
                map.put(key, list);
            }
            list.add(row);
        }
        return map;
    }

    public List<Object[]> dataDimen3(String axisX, String axisY, String color) {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        for (Object o2 : super.toArray()) {
            DataRow row = (DataRow)o2;
            Object[] obj = new Object[]{row.getValue(axisX), row.getValue(axisY), row.getValue(color)};
            list.add(obj);
        }
        return list;
    }

    public List<Object[]> dataDimen4(String axisX, String axisY, String axisZ, String color) {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        for (Object o2 : super.toArray()) {
            DataRow row = (DataRow)o2;
            Object[] obj = new Object[]{row.getValue(axisX), row.getValue(axisY), row.getValue(axisZ), row.getValue(color)};
            list.add(obj);
        }
        return list;
    }
}

