/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.exploration.biz.datatable.column;

import com.datastax.data.exploration.biz.datatable.DataType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class DataColumn<E> {
    public static String ERROR_TYPE = "type";
    private String columnName;
    private DataType type;
    private List<String> data = new ArrayList<String>();
    private List<E> values = new ArrayList();
    private Map<String, List<String>> errors = new HashMap<String, List<String>>();

    public DataColumn(String columnName, DataType dataType) {
        this.columnName = columnName;
        this.type = dataType;
    }

    abstract E transferValue(String var1);

    abstract void flush();

    public E getValue(int i2) {
        return this.values.get(i2);
    }

    public void setData(int i2, String str) {
        Object value = str == null || str.trim().length() == 0 ? null : (Object)this.transferValue(str);
        if (this.data.size() > i2) {
            this.data.set(i2, str);
            this.values.set(i2, value);
        } else {
            this.data.add(str);
            this.values.add(value);
        }
        this.flush();
    }

    public String getData(int i2) {
        return this.data.get(i2);
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public DataType getType() {
        return this.type;
    }

    public void setType(DataType type) {
        this.type = type;
    }

    public int size() {
        return this.data.size();
    }

    public int dataNullSize() {
        int i2 = 0;
        for (String str : this.data) {
            if (str != null && !str.trim().isEmpty()) continue;
            ++i2;
        }
        return i2;
    }

    public int valueNullSize() {
        int i2 = 0;
        for (E value : this.values) {
            if (value != null) continue;
            ++i2;
        }
        return i2;
    }

    private List<String> getData() {
        return this.data;
    }

    private List<E> getValues() {
        return this.values;
    }

    public List<String> getError(String name) {
        return this.errors.get(name);
    }

    void addError(String errorName, String ex) {
        List<String> error = this.errors.get(errorName);
        if (error == null) {
            error = new ArrayList<String>();
            this.errors.put(errorName, error);
        }
        error.add(ex);
    }

    public List<E> getNotNullValues() {
        return this.values.stream().filter(v2 -> v2 != null).collect(Collectors.toList());
    }
}

