/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.exploration.biz.datatable.column;

import com.datastax.data.exploration.biz.datatable.DataType;
import com.datastax.data.exploration.biz.datatable.column.NumberColumn;
import com.datastax.data.exploration.biz.datatable.column.math.MathStat;
import java.math.BigDecimal;

public class DecimalColumn
extends NumberColumn<BigDecimal> {
    private MathStat<BigDecimal> stat = null;

    public DecimalColumn(String columnName) {
        super(columnName, DataType.DECIMAL);
    }

    @Override
    BigDecimal transferValue(String str) {
        try {
            return new BigDecimal(str);
        }
        catch (Exception e2) {
            this.addError(ERROR_TYPE, str);
            return null;
        }
    }

    @Override
    void flush() {
        this.stat = null;
    }

    public MathStat<BigDecimal> getStat() {
        if (this.stat == null) {
            this.stat = new MathStat((Number[])this.getNotNullValues().toArray(new BigDecimal[0]));
        }
        return this.stat;
    }
}

