/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.exploration.biz.datatable.column;

import com.datastax.data.exploration.biz.datatable.DataType;
import com.datastax.data.exploration.biz.datatable.column.NumberColumn;
import com.datastax.data.exploration.biz.datatable.column.math.MathStat;

public class IntegerColumn
extends NumberColumn<Integer> {
    private MathStat<Integer> stat = null;

    public IntegerColumn(String columnName) {
        super(columnName, DataType.INT);
    }

    @Override
    Integer transferValue(String str) {
        try {
            return Integer.valueOf(str);
        }
        catch (Exception e2) {
            this.addError(ERROR_TYPE, str);
            return null;
        }
    }

    @Override
    void flush() {
        this.stat = null;
    }

    public MathStat<Integer> getStat() {
        if (this.stat == null) {
            this.stat = new MathStat((Number[])this.getNotNullValues().toArray(new Integer[0]));
        }
        return this.stat;
    }
}

