/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.exploration.biz.datatable.column;

import com.datastax.data.exploration.biz.datatable.DataType;
import com.datastax.data.exploration.biz.datatable.column.TimestampColumn;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;

public class TimeColumn
extends TimestampColumn {
    public static SimpleDateFormat format = new SimpleDateFormat("HH:mm");

    public TimeColumn(String columnName) {
        super(columnName, DataType.TIME);
    }

    @Override
    Date transferValue(String str) {
        try {
            return format.parse(str);
        }
        catch (Exception e2) {
            this.addError(ERROR_TYPE, str);
            return null;
        }
    }

    @Override
    void flush() {
    }

    public Date max() {
        return this.getNotNullValues().stream().max(Comparator.comparingLong(Date::getTime)).orElse(null);
    }

    public Date min() {
        return this.getNotNullValues().stream().min(Comparator.comparingLong(Date::getTime)).orElse(null);
    }
}

