/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.exploration.biz.datatable.column.math;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public enum Function {
    COUNT("\u8ba1\u6570"),
    MEAN("\u5e73\u5747"),
    VARIANCE("\u65b9\u5dee"),
    STANDARD_DEVIATION("\u6807\u51c6\u5dee"),
    MAX("\u6700\u5927\u503c"),
    MIN("\u6700\u5c0f\u503c"),
    SUM("\u6c42\u548c"),
    MODE("\u4f17\u6570"),
    MEDIAN("\u4e2d\u4f4d\u6570");

    private String name;

    private Function(@Nonnull String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static Function getFunction(String name) {
        for (Function function : Function.values()) {
            if (!function.name.equals(name)) continue;
            return function;
        }
        return null;
    }

    public static List<String> getFunctions() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(COUNT.getName());
        list.add(MEAN.getName());
        list.add(VARIANCE.getName());
        list.add(STANDARD_DEVIATION.getName());
        list.add(MAX.getName());
        list.add(MIN.getName());
        list.add(SUM.getName());
        list.add(MODE.getName());
        list.add(MEDIAN.getName());
        return list;
    }
}

