/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.exploration.biz.datatable.column.math;

import com.datastax.data.exploration.biz.datatable.column.math.Function;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.math3.stat.descriptive.moment.Kurtosis;
import org.apache.commons.math3.stat.descriptive.moment.Mean;
import org.apache.commons.math3.stat.descriptive.moment.Skewness;
import org.apache.commons.math3.stat.descriptive.moment.StandardDeviation;
import org.apache.commons.math3.stat.descriptive.moment.Variance;
import org.apache.commons.math3.stat.descriptive.rank.Max;
import org.apache.commons.math3.stat.descriptive.rank.Min;
import org.apache.commons.math3.stat.descriptive.rank.Percentile;
import org.apache.commons.math3.stat.descriptive.summary.Sum;

public class MathStat<C extends Number> {
    private C[] values = null;
    private double[] doubles = null;
    private Percentile percentile = null;
    private double[] percentileRank = null;
    private int count = 0;

    public MathStat(C[] values) {
        this.values = values;
        this.count = this.values.length;
        this.doubles = Arrays.stream(this.values).mapToDouble(Number::doubleValue).toArray();
        this.percentile = new Percentile();
        this.percentile.setData(this.doubles);
    }

    public MathStat(int count) {
        this.count = count;
    }

    public boolean typeIsNumber() {
        return this.values != null;
    }

    public double calculate(Function func) {
        if (this.values == null) {
            if (Function.COUNT.equals((Object)func)) {
                return this.count;
            }
            return 0.0;
        }
        switch (func) {
            case COUNT: {
                return this.count;
            }
            case MEAN: {
                return this.scale(this.mean());
            }
            case VARIANCE: {
                return this.scale(this.variance());
            }
            case STANDARD_DEVIATION: {
                return this.scale(this.standardDeviation());
            }
            case MAX: {
                return this.scale(this.max());
            }
            case MIN: {
                return this.scale(this.min());
            }
            case SUM: {
                return this.scale(this.sum());
            }
            case MODE: {
                List<C> values = this.mode();
                return values != null && values.size() > 0 ? ((Number)values.get(0)).doubleValue() : 0.0;
            }
            case MEDIAN: {
                return this.scale(this.median());
            }
        }
        return 0.0;
    }

    private double scale(double d2) {
        if (d2 < 1.0) {
            return new BigDecimal(d2).setScale(5, RoundingMode.UP).doubleValue();
        }
        if (d2 < 10.0) {
            return new BigDecimal(d2).setScale(3, RoundingMode.UP).doubleValue();
        }
        return new BigDecimal(d2).setScale(2, RoundingMode.UP).doubleValue();
    }

    private double sum() {
        return new Sum().evaluate(this.doubles);
    }

    public double mean() {
        return new Mean().evaluate(this.doubles);
    }

    public List<C> mode() {
        Map<Number, Long> group = Arrays.stream(this.values).collect(Collectors.groupingBy(n2 -> n2, Collectors.counting()));
        HashMap map = new HashMap();
        group.forEach((k2, v2) -> {
            map.putIfAbsent(v2, new ArrayList());
            ((List)map.get(v2)).add(k2);
        });
        Long max = map.keySet().stream().sorted(Comparator.reverseOrder()).findFirst().orElse(Long.MAX_VALUE);
        if (((List)map.get(max)).size() < 10) {
            return (List)map.get(max);
        }
        return new ArrayList();
    }

    public double max() {
        return new Max().evaluate(this.doubles);
    }

    public double min() {
        return new Min().evaluate(this.doubles);
    }

    public double range() {
        return this.max() - this.min();
    }

    public double variance() {
        return new Variance().evaluate(this.doubles);
    }

    public double standardDeviation() {
        return new StandardDeviation().evaluate(this.doubles);
    }

    public double variationCoefficient() {
        return this.standardDeviation() / this.mean();
    }

    public double skewness() {
        return new Skewness().evaluate(this.doubles);
    }

    public double kurtosis() {
        return new Kurtosis().evaluate(this.doubles);
    }

    public double[] percentile() {
        if (this.percentileRank == null) {
            double[] p2 = new double[100];
            for (int i2 = 0; i2 < 100; ++i2) {
                p2[i2] = this.percentile(i2 + 1);
            }
            this.percentileRank = p2;
        }
        return this.percentileRank;
    }

    private double percentile(int i2) {
        return this.percentile.evaluate((double)i2);
    }

    public double[] quartile() {
        double[] p2 = this.percentile();
        double[] q2 = new double[]{p2[24], p2[49], p2[74]};
        return q2;
    }

    public double median() {
        return this.quartile()[1];
    }
}

