/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.exploration.biz.quartz;

import java.io.File;
import java.util.Date;
import org.quartz.Job;
import org.quartz.JobExecutionContext;

public class DeleteTimerJob
implements Job {
    public void execute(JobExecutionContext context) {
        File parentDir = new File("/tmp/exploration/data");
        if (parentDir.isDirectory()) {
            long timeNow = new Date().getTime();
            DeleteTimerJob.deleteFolder(parentDir, timeNow);
        }
    }

    public static void deleteFolder(File folder, long timeNow) {
        File[] files = folder.listFiles();
        if (files != null) {
            for (File f2 : files) {
                if (f2.isDirectory()) {
                    DeleteTimerJob.deleteFolder(f2, timeNow);
                    continue;
                }
                Long timeFile = f2.lastModified();
                long difference = timeNow - timeFile;
                int hour = (int)(difference / 3600000L);
                if (hour <= 24) continue;
                f2.delete();
            }
        }
    }
}

