/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.exploration.biz.report.detector.error;

import com.alibaba.fastjson.JSONObject;
import com.datastax.data.exploration.biz.datatable.DataTable;
import com.datastax.data.exploration.biz.datatable.column.BinomialColumn;
import com.datastax.data.exploration.biz.datatable.column.DataColumn;
import com.datastax.data.exploration.biz.datatable.column.DateColumn;
import com.datastax.data.exploration.biz.datatable.column.PolynomialColumn;
import com.datastax.data.exploration.biz.report.detector.AbstractDetector;
import com.datastax.data.exploration.biz.report.detector.error.ErrorData;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ErrorDataDetector
extends AbstractDetector {
    @Override
    public String detect(DataTable table) {
        ArrayList<ErrorData> errors = new ArrayList<ErrorData>();
        for (DataColumn column : table.getColumns()) {
            Map<String, Long> agg;
            List<String> typeErrors;
            int dataNullSize = column.dataNullSize();
            if (dataNullSize > 0) {
                errors.add(new ErrorData(column.getColumnName(), column.getType().getName(), "\u5b58\u5728\u7a7a\u503c", dataNullSize));
            }
            if ((typeErrors = column.getError(DateColumn.ERROR_TYPE)) != null && typeErrors.size() > 0) {
                HashSet<String> set = new HashSet<String>();
                set.addAll(typeErrors);
                errors.add(new ErrorData(column.getColumnName(), column.getType().getName(), Joiner.on((String)",").join(set), typeErrors.size()));
            }
            if (column instanceof BinomialColumn) {
                agg = ((BinomialColumn)column).aggCount();
                if (agg == null || agg.size() <= 2) continue;
                errors.add(new ErrorData(column.getColumnName(), column.getType().getName(), Joiner.on((String)";").withKeyValueSeparator("->").join(agg), agg.size()));
                continue;
            }
            if (!(column instanceof PolynomialColumn) || (agg = ((PolynomialColumn)column).aggCount()) == null || agg.size() <= 10) continue;
            errors.add(new ErrorData(column.getColumnName(), column.getType().getName(), Joiner.on((String)";").withKeyValueSeparator("->").join(agg), agg.size()));
        }
        return JSONObject.toJSONString(errors);
    }
}

