/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.exploration.biz.stat;

import com.datastax.data.exploration.biz.chiSquare.ChiSquare;
import com.datastax.data.exploration.biz.datatable.DataTable;
import com.datastax.data.exploration.common.DataOperator;
import com.datastax.data.exploration.dto.dataChart.stackedBar.Crosstab;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.javatuples.Pair;

public class Cross {
    public static String[] getSummary(String id) {
        String[] summary2 = new String[6];
        long exactCount = DataOperator.readExactData(id).size();
        long errorCount = DataOperator.readErrorData(id).size();
        summary2[0] = String.valueOf(exactCount);
        summary2[1] = Cross.setCale((double)exactCount / (double)(exactCount + errorCount) * 100.0) + "%";
        summary2[2] = String.valueOf(errorCount);
        summary2[3] = Cross.setCale((double)errorCount / (double)(exactCount + errorCount) * 100.0) + "%";
        summary2[4] = String.valueOf(exactCount + errorCount);
        summary2[5] = "100.0%";
        return summary2;
    }

    public static Crosstab.ModuleData getContentModule(Map<Func, String> map, String group, List<String> groupSubs, Pair<List<List<Long>>, List<Long>> pair, Pair<Long, List<Long>> pairTotal) {
        List groupCounts = (List)pair.getValue0();
        List stackCountTotals = (List)pair.getValue1();
        long countSum = (Long)pairTotal.getValue0();
        List groupCountTotals = (List)pairTotal.getValue1();
        ArrayList<Crosstab.GroupData> groupDatas = new ArrayList<Crosstab.GroupData>();
        for (int grp = 0; grp < groupSubs.size(); ++grp) {
            ArrayList<Crosstab.Data> dataList = new ArrayList<Crosstab.Data>();
            long stackCountTotal = (Long)stackCountTotals.get(grp);
            for (Func func : map.keySet()) {
                List rowValue = Cross.rowCal(func, groupCountTotals, (List)groupCounts.get(grp), stackCountTotal, countSum);
                dataList.add(new Crosstab.Data(map.get((Object)func), rowValue));
            }
            groupDatas.add(new Crosstab.GroupData(groupSubs.get(grp), dataList));
        }
        return new Crosstab.ModuleData(group, groupDatas);
    }

    public static Crosstab.GroupData getTotalModule(Map<Func, String> map, List<Long> groupCountTotals, long countSum) {
        int stackSubSize = groupCountTotals.size();
        groupCountTotals.add(countSum);
        ArrayList<Crosstab.Data> totalDatas = new ArrayList<Crosstab.Data>();
        ArrayList<BigDecimal> expectTotal = new ArrayList<BigDecimal>();
        ArrayList<String> perRowTotal = new ArrayList<String>();
        ArrayList<String> perColTotal = new ArrayList<String>();
        for (int stk = 0; stk < stackSubSize + 1; ++stk) {
            if (stk < stackSubSize) {
                expectTotal.add(Cross.setCale(groupCountTotals.get(stk).longValue()));
                perRowTotal.add(Cross.setCale((double)groupCountTotals.get(stk).longValue() / (double)countSum * 100.0) + "%");
            } else {
                expectTotal.add(Cross.setCale(countSum));
                perRowTotal.add("100.0%");
            }
            perColTotal.add("100.0%");
        }
        ArrayList<String> perSumTotal = perRowTotal;
        totalDatas.add(new Crosstab.Data(map.get((Object)Func.COUNT), groupCountTotals));
        totalDatas.add(new Crosstab.Data(map.get((Object)Func.EXPECT), expectTotal));
        totalDatas.add(new Crosstab.Data(map.get((Object)Func.PERCENT_ROW), perRowTotal));
        totalDatas.add(new Crosstab.Data(map.get((Object)Func.PERCENT_COLUMN), perColTotal));
        totalDatas.add(new Crosstab.Data(map.get((Object)Func.PERCENT_TOTAL), perSumTotal));
        return new Crosstab.GroupData("\u5408\u8ba1", totalDatas);
    }

    public static List<Crosstab.ChiSquare> getChiSquare(List<List<Long>> groupCounts, long n2) {
        ArrayList<Crosstab.ChiSquare> chiSquares = new ArrayList<Crosstab.ChiSquare>();
        int groupSize = groupCounts.size();
        if (groupSize > 1 && groupCounts.get(0).size() > 1) {
            int stackSize = groupCounts.get(0).size();
            int df = (groupSize - 1) * (stackSize - 1);
            long[][] counts = new long[groupSize][stackSize];
            for (int grp = 0; grp < groupSize; ++grp) {
                for (int co = 0; co < stackSize; ++co) {
                    counts[grp][co] = groupCounts.get(grp).get(co);
                }
            }
            BigDecimal chiVal = Cross.setCale(ChiSquare.chiValue(counts));
            BigDecimal pVal = Cross.setCale(ChiSquare.chiPvalue(counts));
            chiSquares.add(new Crosstab.ChiSquare("Perarson \u5361\u65b9", String.valueOf(chiVal), String.valueOf(df), String.valueOf(pVal)));
            chiSquares.add(new Crosstab.ChiSquare("\u6709\u6548\u6848\u4f8b\u4e2d\u7684N", String.valueOf(n2), "", ""));
        } else {
            chiSquares.add(new Crosstab.ChiSquare("Perarson \u5361\u65b9", "\u65e0", "\u65e0", "\u65e0"));
            chiSquares.add(new Crosstab.ChiSquare("\u6709\u6548\u6848\u4f8b\u4e2d\u7684N", String.valueOf(n2), "", ""));
        }
        return chiSquares;
    }

    public static Pair<List<List<Long>>, List<Long>> getCount(DataTable table, String group, String stack) {
        Map<String, Map<String, Long>> aggSubCounts = Cross.aggSubCounts(table, group, stack);
        ArrayList stackCountTotals = new ArrayList();
        ArrayList groupCounts = new ArrayList();
        aggSubCounts.forEach((grp, stks) -> {
            ArrayList counts = new ArrayList();
            AtomicLong countTotal = new AtomicLong();
            stks.forEach((k2, v2) -> {
                countTotal.addAndGet((long)v2);
                counts.add(v2);
            });
            stackCountTotals.add(countTotal.get());
            groupCounts.add(counts);
        });
        return Pair.with(groupCounts, stackCountTotals);
    }

    public static Pair<Long, List<Long>> getCountTotals(List<List<Long>> groupCounts) {
        if (groupCounts.size() > 0) {
            long countSum = 0L;
            ArrayList<Long> groupCountTotals = new ArrayList<Long>();
            for (int stk = 0; stk < groupCounts.get(0).size(); ++stk) {
                long groupConutTotal = 0L;
                for (int grp = 0; grp < groupCounts.size(); ++grp) {
                    groupConutTotal += groupCounts.get(grp).get(stk).longValue();
                }
                countSum += groupConutTotal;
                groupCountTotals.add(groupConutTotal);
            }
            return Pair.with((Object)countSum, groupCountTotals);
        }
        return new Pair((Object)0L, (Object)Collections.EMPTY_LIST);
    }

    private static List rowCal(Func func, List<Long> groupCountTotals, List<Long> groupCounts, long stackCountTotal, long countSum) {
        int stackSubSize = groupCountTotals.size();
        switch (func) {
            case COUNT: {
                ArrayList<Long> count = new ArrayList<Long>();
                count.addAll(groupCounts);
                count.add(stackCountTotal);
                return count;
            }
            case EXPECT: {
                ArrayList<BigDecimal> expectValue = new ArrayList<BigDecimal>();
                for (int stk = 0; stk < stackSubSize; ++stk) {
                    double value = (double)groupCountTotals.get(stk).longValue() / (double)countSum * (double)stackCountTotal;
                    expectValue.add(Cross.setCale(value));
                }
                expectValue.add(Cross.setCale(stackCountTotal));
                return expectValue;
            }
            case PERCENT_ROW: {
                ArrayList<String> perValue = new ArrayList<String>();
                for (int stk = 0; stk < stackSubSize; ++stk) {
                    double value = (double)groupCounts.get(stk).longValue() / (double)stackCountTotal * 100.0;
                    perValue.add(Cross.setCale(value) + "%");
                }
                perValue.add("100.0%");
                return perValue;
            }
            case PERCENT_COLUMN: {
                ArrayList<String> perColValue = new ArrayList<String>();
                for (int stk = 0; stk < stackSubSize; ++stk) {
                    double value = (double)groupCounts.get(stk).longValue() / (double)groupCountTotals.get(stk).longValue() * 100.0;
                    perColValue.add(Cross.setCale(value) + "%");
                }
                perColValue.add(Cross.setCale((double)stackCountTotal / (double)countSum * 100.0) + "%");
                return perColValue;
            }
            case PERCENT_TOTAL: {
                ArrayList<String> perTotalValue = new ArrayList<String>();
                for (int stk = 0; stk < stackSubSize; ++stk) {
                    double value = (double)groupCounts.get(stk).longValue() / (double)countSum * 100.0;
                    perTotalValue.add(Cross.setCale(value) + "%");
                }
                perTotalValue.add(Cross.setCale((double)stackCountTotal / (double)countSum * 100.0) + "%");
                return perTotalValue;
            }
            case RESIDUAL_UN: {
                ArrayList<Object> residualValue = new ArrayList<Object>();
                for (int stk = 0; stk < stackSubSize; ++stk) {
                    double expectValue = (double)groupCountTotals.get(stk).longValue() / (double)countSum * (double)stackCountTotal;
                    double value = (double)groupCounts.get(stk).longValue() - expectValue;
                    residualValue.add(Cross.setCale(value));
                }
                residualValue.add("");
                return residualValue;
            }
        }
        return Collections.EMPTY_LIST;
    }

    public static Map<Func, String> getFuncs(String group, String stack) {
        LinkedHashMap<Func, String> map = new LinkedHashMap<Func, String>();
        map.put(Func.COUNT, "\u8ba1\u6570");
        map.put(Func.EXPECT, "\u671f\u671b\u7684\u8ba1\u6570");
        map.put(Func.PERCENT_ROW, group + " \u4e2d\u7684%");
        map.put(Func.PERCENT_COLUMN, stack + " \u4e2d\u7684%");
        map.put(Func.PERCENT_TOTAL, "\u603b\u6570\u7684%");
        map.put(Func.RESIDUAL_UN, "\u6b8b\u5dee");
        return map;
    }

    private static Map<String, Map<String, Long>> aggSubCounts(DataTable table, String groupName, String valueName) {
        HashMap<String, Map<String, Long>> map = new HashMap<String, Map<String, Long>>();
        table.getRows().aggList(groupName).forEach((k2, v2) -> {
            List list = v2.parallelStream().map(row -> row.getValue(valueName)).collect(Collectors.toList());
            map.put((String)k2, list.parallelStream().map(e2 -> String.valueOf(e2)).collect(Collectors.groupingBy(s2 -> s2, Collectors.counting())));
        });
        return map;
    }

    private static BigDecimal setCale(double value) {
        return new BigDecimal(value).setScale(1, RoundingMode.UP);
    }

    public static enum Func {
        COUNT,
        EXPECT,
        PERCENT_ROW,
        PERCENT_COLUMN,
        PERCENT_TOTAL,
        RESIDUAL_UN;

    }
}

