/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.exploration.biz.stat;

import com.alibaba.fastjson.JSONObject;
import com.datastax.data.exploration.biz.datatable.DataTable;
import com.datastax.data.exploration.biz.datatable.column.NomialColumn;
import com.datastax.data.exploration.common.File2DataTable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.javatuples.Pair;

public class Pareto {
    public static List<JSONObject> operator(String id, String group, String val, String valSub) {
        DataTable table = File2DataTable.exactTable(id);
        List<Pair<Long, String>> pairs = Pareto.sortGroup(table, group, val, valSub);
        long lineGrpCount = 0L;
        long lineGrpSubCount = 0L;
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        for (Pair<Long, String> pair : pairs) {
            JSONObject json = new JSONObject();
            long count = (Long)pair.getValue0();
            if ("NONE".equals(valSub)) {
                json.put("barVal", (Object)new long[]{-1L, count});
                json.put("lineVal", (Object)new long[]{-1L, lineGrpCount += count});
            } else {
                long barGrpCount = ((NomialColumn)table.getColumns().getColumn(group)).aggCount().get(pair.getValue1());
                json.put("barVal", (Object)new long[]{count, barGrpCount});
                json.put("lineVal", (Object)new long[]{lineGrpSubCount += count, lineGrpCount += barGrpCount});
            }
            json.put("group", pair.getValue1());
            list.add(json);
        }
        return list;
    }

    private static List<Pair<Long, String>> sortGroup(DataTable table, String group, String val, String valSub) {
        ArrayList pairs = new ArrayList();
        if ("NONE".equals(valSub)) {
            Map<String, Long> aggCount = ((NomialColumn)table.getColumns().getColumn(group)).aggCount();
            aggCount.forEach((k2, v2) -> pairs.add(new Pair(v2, k2)));
        } else {
            Map<String, Long> aggCount = Pareto.aggSubCount(table, group, val, valSub);
            aggCount.forEach((k2, v2) -> {
                if (v2 != null) {
                    pairs.add(new Pair(v2, k2));
                }
            });
        }
        return pairs.stream().sorted((p1, p2) -> ((Long)p2.getValue0()).compareTo((Long)p1.getValue0())).collect(Collectors.toList());
    }

    private static Map<String, Long> aggSubCount(DataTable table, String group, String val, String valueSub) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        table.getRows().aggList(group).forEach((k2, v2) -> {
            List list = v2.parallelStream().map(row -> row.getValue(val)).collect(Collectors.toList());
            map.put((String)k2, list.parallelStream().collect(Collectors.groupingBy(s2 -> s2, Collectors.counting())).get(valueSub));
        });
        return map;
    }
}

