/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.exploration.biz.stat;

import com.alibaba.fastjson.JSONObject;
import com.datastax.data.exploration.biz.datatable.DataTable;
import com.datastax.data.exploration.biz.datatable.column.NumberColumn;
import com.datastax.data.exploration.biz.datatable.column.math.Function;
import com.datastax.data.exploration.biz.datatable.column.math.MathStat;
import com.datastax.data.exploration.common.File2DataTable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Pie {
    public static List<JSONObject> operator(String id, String group, String val, String func) {
        ArrayList<JSONObject> listValue = new ArrayList<JSONObject>();
        DataTable table = File2DataTable.exactTable(id);
        Function function = Function.getFunction(func);
        Pie.aggMath(table, group, val).forEach((k2, v2) -> {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("name", k2);
            if (v2.typeIsNumber()) {
                jsonObject.put("value", (Object)v2.calculate(function));
            } else if (Function.COUNT.equals((Object)function)) {
                jsonObject.put("value", (Object)v2.calculate(function));
            }
            listValue.add(jsonObject);
        });
        return listValue;
    }

    private static Map<String, MathStat> aggMath(DataTable table, String group, String val) {
        HashMap<String, MathStat> map = new HashMap<String, MathStat>();
        table.getRows().aggList(group).forEach((k2, v2) -> {
            if (!"NONE".equals(val) && table.getColumns().getColumn(val) instanceof NumberColumn) {
                List<Number> list = v2.parallelStream().map(row -> row.getValue(val)).collect(Collectors.toList());
                map.put((String)k2, new MathStat(list.toArray(new Number[0])));
            } else {
                map.put((String)k2, new MathStat(v2.size()));
            }
        });
        return map;
    }
}

