/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.exploration.biz.stat;

import com.datastax.data.exploration.biz.datatable.DataRow;
import com.datastax.data.exploration.biz.datatable.DataTable;
import com.datastax.data.exploration.biz.datatable.column.NumberColumn;
import com.datastax.data.exploration.biz.datatable.column.math.Function;
import com.datastax.data.exploration.biz.datatable.column.math.MathStat;
import com.datastax.data.exploration.common.File2DataTable;
import com.datastax.data.exploration.dto.dataChart.stackedBar.StackedBarChartValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StackedBar {
    public static List<StackedBarChartValue> operator(String id, String group, String stack, String val, String func) {
        DataTable table = File2DataTable.exactTable(id);
        Map<String, Map<String, MathStat>> mapSub = StackedBar.aggSubList(table, group, stack, val);
        Function function = Function.getFunction(func);
        ArrayList<StackedBarChartValue> listStackBarValue = new ArrayList<StackedBarChartValue>();
        mapSub.forEach((k2, v2) -> {
            StackedBarChartValue stackedBarValue = new StackedBarChartValue((String)k2);
            v2.forEach((ksub, vsub) -> {
                double value = 0.0;
                if (vsub.typeIsNumber()) {
                    value = vsub.calculate(function);
                } else if (Function.COUNT.equals((Object)function)) {
                    value = vsub.calculate(function);
                }
                stackedBarValue.put((String)ksub, value);
            });
            listStackBarValue.add(stackedBarValue);
        });
        return listStackBarValue;
    }

    private static Map<String, Map<String, MathStat>> aggSubList(DataTable table, String group, String stack, String val) {
        HashMap<String, Map<String, MathStat>> mapSub = new HashMap<String, Map<String, MathStat>>();
        table.getRows().aggList(group).forEach((k2, v2) -> {
            HashMap mapMath = new HashMap();
            if (!"NONE".equals(val)) {
                HashMap<Object, List> map = new HashMap<Object, List>();
                for (DataRow row : v2) {
                    Object key = row.getValue(stack);
                    Object item = row.getValue(val);
                    if (key == null || item == null) continue;
                    ArrayList<Object> list = (ArrayList<Object>)map.get(key);
                    if (list == null) {
                        list = new ArrayList<Object>();
                        map.put(key, list);
                    }
                    list.add(item);
                }
                map.forEach((ksub, vsub) -> {
                    if (table.getColumns().getColumn(val) instanceof NumberColumn) {
                        mapMath.put((String)ksub, new MathStat(vsub.toArray(new Number[0])));
                    } else {
                        mapMath.put((String)ksub, new MathStat(vsub.size()));
                    }
                });
            } else {
                HashMap<Object, Integer> map = new HashMap<Object, Integer>();
                for (DataRow row : v2) {
                    Object key = row.getValue(stack);
                    if (key == null) continue;
                    Integer count = (Integer)map.get(key);
                    if (count == null) {
                        count = 0;
                    }
                    Integer n2 = count;
                    Integer n3 = count = Integer.valueOf(count + 1);
                    map.put(key, count);
                }
                map.forEach((ksub, vsub) -> mapMath.put((String)ksub, new MathStat((int)vsub)));
            }
            mapSub.put((String)k2, mapMath);
        });
        return mapSub;
    }
}

