/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.exploration.biz.stat.bar;

import com.datastax.data.exploration.biz.datatable.column.DataColumn;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class BarStat<C extends DataColumn> {
    C column;
    private Stat stat;
    private String most;
    private String least;
    private long mostCount;
    private long leastCount;

    BarStat(C column) {
        this.column = column;
        int count = ((DataColumn)this.column).getNotNullValues().size();
        this.stat = new Stat();
        this.agg().forEach((k2, v2) -> {
            if (this.most == null) {
                this.most = k2;
                this.least = k2;
                this.mostCount = v2;
                this.leastCount = v2;
            } else if (v2 > this.mostCount) {
                this.most = k2;
                this.mostCount = v2;
            } else if (v2 < this.leastCount) {
                this.least = k2;
                this.leastCount = v2;
            }
            this.stat.xAxis.add((String)k2);
            this.stat.yAxis.add((Long)v2);
            this.stat.percent.add(this.percent((Long)v2, count));
        });
    }

    abstract Map<String, Long> agg();

    public Stat getStat() {
        return this.stat;
    }

    public String getMost() {
        return this.most;
    }

    public String getLeast() {
        return this.least;
    }

    public long getMostCount() {
        return this.mostCount;
    }

    public long getLeastCount() {
        return this.leastCount;
    }

    private BigDecimal percent(Long current, int count) {
        return BigDecimal.valueOf(current).divide(BigDecimal.valueOf(count), 4, RoundingMode.UP);
    }

    private class Stat {
        List<BigDecimal> percent = new ArrayList<BigDecimal>();
        List<String> xAxis = new ArrayList<String>();
        List<Long> yAxis = new ArrayList<Long>();

        private Stat() {
        }

        public List<BigDecimal> getPercent() {
            return this.percent;
        }

        public List<String> getXAxis() {
            return this.xAxis;
        }

        public List<Long> getYAxis() {
            return this.yAxis;
        }
    }
}

