/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.exploration.biz.stat.executor;

import com.datastax.data.exploration.biz.datatable.column.DataColumn;
import com.datastax.data.exploration.biz.datatable.column.math.MathStat;
import com.datastax.data.exploration.biz.stat.executor.StatExecutor;
import com.datastax.data.exploration.biz.stat.histogram.HistogramStat;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class NumberExecutor<C extends DataColumn, B extends Number>
extends StatExecutor<C> {
    HistogramStat<C, B> histogram;

    NumberExecutor(C column) {
        super(column);
    }

    abstract MathStat<B> getStat();

    public HistogramStat<C, B> getHistogram() {
        return this.histogram;
    }

    @Override
    void statOther() {
        this.info.setMean(this.string(this.getStat().mean()));
        this.info.setMode(this.toModeString());
        this.info.setMax(this.string(this.getStat().max()));
        this.info.setMin(this.string(this.getStat().min()));
        this.info.setRange(this.string(this.getStat().range()));
        this.info.setVariance(this.string(this.getStat().variance()));
        this.info.setDeviation(this.string(this.getStat().standardDeviation()));
        this.info.setCoefficient(this.string(this.getStat().variationCoefficient()));
        this.info.setSkewness(this.string(this.getStat().skewness()));
        this.info.setKurtosis(this.string(this.getStat().kurtosis()));
        this.info.setPercentile(new ArrayList<String>());
        Arrays.stream(this.getStat().percentile()).forEach(p2 -> this.info.getPercentile().add(this.string(p2)));
        this.info.setQuartile(new ArrayList<String>());
        Arrays.stream(this.getStat().quartile()).forEach(q2 -> this.info.getQuartile().add(this.string(q2)));
        this.info.setMedian(this.string(this.getStat().median()));
        this.info.setData(this.histogram.stage());
    }

    private List<String> toModeString() {
        List<B> ints = this.getStat().mode();
        ArrayList<String> list = new ArrayList<String>();
        for (Number number : ints) {
            list.add(this.string(number.doubleValue()));
        }
        return list;
    }

    private String string(double d2) {
        if (d2 < 1.0) {
            return this.scale(d2, 5).stripTrailingZeros().toPlainString();
        }
        if (d2 < 10.0) {
            return this.scale(d2, 3).stripTrailingZeros().toPlainString();
        }
        return this.scale(d2, 2).stripTrailingZeros().toPlainString();
    }

    private BigDecimal scale(double d2, int scale) {
        return new BigDecimal(d2).setScale(scale, RoundingMode.UP);
    }
}

