/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.exploration.biz.stat.executor;

import com.datastax.data.exploration.biz.datatable.column.BinomialColumn;
import com.datastax.data.exploration.biz.datatable.column.DataColumn;
import com.datastax.data.exploration.biz.datatable.column.DateColumn;
import com.datastax.data.exploration.biz.datatable.column.DateTimeColumn;
import com.datastax.data.exploration.biz.datatable.column.DecimalColumn;
import com.datastax.data.exploration.biz.datatable.column.IntegerColumn;
import com.datastax.data.exploration.biz.datatable.column.PolynomialColumn;
import com.datastax.data.exploration.biz.datatable.column.TextColumn;
import com.datastax.data.exploration.biz.datatable.column.TimeColumn;
import com.datastax.data.exploration.biz.stat.executor.BinomialStat;
import com.datastax.data.exploration.biz.stat.executor.DateStat;
import com.datastax.data.exploration.biz.stat.executor.DateTimeStat;
import com.datastax.data.exploration.biz.stat.executor.DecimalStat;
import com.datastax.data.exploration.biz.stat.executor.DefaultStat;
import com.datastax.data.exploration.biz.stat.executor.IntegerStat;
import com.datastax.data.exploration.biz.stat.executor.PolynomialStat;
import com.datastax.data.exploration.biz.stat.executor.StatExecutor;
import com.datastax.data.exploration.biz.stat.executor.TextStat;
import com.datastax.data.exploration.biz.stat.executor.TimeStat;

public class StatExecutorFactory {
    public static StatExecutor createStatExecutor(DataColumn column) {
        switch (column.getType()) {
            case DATE_TIME: {
                return new DateTimeStat((DateTimeColumn)column);
            }
            case DATE: {
                return new DateStat((DateColumn)column);
            }
            case TIME: {
                return new TimeStat((TimeColumn)column);
            }
            case INT: {
                return new IntegerStat((IntegerColumn)column);
            }
            case DECIMAL: {
                return new DecimalStat((DecimalColumn)column);
            }
            case BINOMIAL: {
                return new BinomialStat((BinomialColumn)column);
            }
            case POLYNOMIAL: {
                return new PolynomialStat((PolynomialColumn)column);
            }
            case TEXT: {
                return new TextStat((TextColumn)column);
            }
        }
        return new DefaultStat(column);
    }
}

