/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.exploration.biz.stat.histogram;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class Stage {
    private static int DEFAULT_GROUP = 6;
    private double min;
    private double max;
    private int group;
    private double interval_min;
    private double interval_max;
    private double start_min;
    private double start_max;
    private double start;
    private double interval;

    public Stage(int min, int max) {
        this((double)min, (double)max);
    }

    public Stage(double min, double max) {
        this.min = min;
        this.max = max;
    }

    public List<Object[]> split() {
        return this.split(DEFAULT_GROUP);
    }

    public List<Object[]> split(int group) {
        this.group = group;
        this.interval_min = (this.max - this.min) / (double)group;
        this.interval_max = (this.max - this.min) / (double)(group - 2);
        this.start_min = this.min - this.interval_max;
        this.start_max = this.min;
        this.start();
        this.interval();
        return this.stages();
    }

    private void start() {
        double tmp;
        int i2;
        this.start = this.min;
        int index = String.valueOf(this.min).indexOf(".");
        if (index > 0) {
            int min_decimal_len = String.valueOf(this.min).length() - 1 - index;
            for (i2 = 1; i2 <= min_decimal_len; ++i2) {
                tmp = this.min > 0.0 ? BigDecimal.valueOf(this.min).setScale(min_decimal_len - i2, 1).doubleValue() : BigDecimal.valueOf(this.min).setScale(min_decimal_len - i2, 0).doubleValue();
                if (!(tmp >= this.start_min) || !(tmp <= this.start_max)) continue;
                this.start = tmp;
            }
        }
        int min_int_len = String.valueOf((int)Math.ceil(this.min)).length();
        for (i2 = 1; i2 <= min_int_len; ++i2) {
            tmp = (int)(Math.floor(this.min / Math.pow(10.0, i2)) * Math.pow(10.0, i2));
            if (!(tmp >= this.start_min) || !(tmp <= this.start_max)) continue;
            this.start = tmp;
        }
    }

    private void interval() {
        double tmp;
        int i2;
        if (this.min - this.start > this.interval_min) {
            this.interval_min = this.min - this.start;
        }
        if ((this.max - this.start) / (double)this.group > this.interval_min) {
            this.interval_min = (this.max - this.start) / (double)this.group;
        }
        if ((this.max - this.start) / (double)(this.group - 1) < this.interval_max) {
            this.interval_max = (this.max - this.start) / (double)(this.group - 1);
        }
        this.interval = this.interval_min;
        int index = String.valueOf(this.interval_min).indexOf(".");
        if (index > 0) {
            int min_decimal_len = String.valueOf(this.interval_min).length() - 1 - index;
            for (i2 = 1; i2 <= min_decimal_len; ++i2) {
                tmp = BigDecimal.valueOf(this.interval_min).setScale(min_decimal_len - i2, 0).doubleValue();
                if (!(tmp >= this.interval_min) || !(tmp <= this.interval_max)) continue;
                this.interval = tmp;
            }
        }
        int max_int_len = String.valueOf((int)Math.ceil(this.interval_max)).length();
        for (i2 = 1; i2 <= max_int_len; ++i2) {
            tmp = (int)(Math.ceil(this.interval_min / Math.pow(10.0, i2)) * Math.pow(10.0, i2));
            if (!(tmp >= this.interval_min) || !(tmp <= this.interval_max)) continue;
            this.interval = tmp;
        }
    }

    private List<Object[]> stages() {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        if ((double)((int)this.start) == this.start && (double)((int)this.interval) == this.interval) {
            int temp = (int)this.start;
            int stage = (int)this.interval;
            for (int i2 = 1; i2 <= this.group; ++i2) {
                list.add(new Integer[]{temp, temp + stage, 0});
                temp += stage;
            }
            return list;
        }
        if ((double)((long)this.start) == this.start && (double)((long)this.interval) == this.interval) {
            long temp = (long)this.start;
            long stage = (long)this.interval;
            for (int i3 = 1; i3 <= this.group; ++i3) {
                list.add(new Object[]{temp, temp + stage, 0});
                temp += stage;
            }
            return list;
        }
        BigDecimal temp = BigDecimal.valueOf(this.start);
        for (int i4 = 1; i4 <= this.group; ++i4) {
            list.add(new Object[]{temp.doubleValue(), temp.add(BigDecimal.valueOf(this.interval)).doubleValue(), 0});
            temp = temp.add(BigDecimal.valueOf(this.interval));
        }
        return list;
    }
}

