/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.exploration.biz.stat.histogram;

import com.datastax.data.exploration.biz.datatable.column.TimeColumn;
import com.datastax.data.exploration.biz.stat.histogram.HistogramStat;
import java.util.Date;
import java.util.stream.Collectors;

public class TimeHistogram
extends HistogramStat<TimeColumn, Long> {
    public TimeHistogram(TimeColumn column) {
        super(column);
        this.max = column.max().getTime();
        this.min = column.min().getTime();
        this.list = column.getNotNullValues().stream().map(Date::getTime).collect(Collectors.toList());
    }

    @Override
    int count(double start2, double end, boolean last) {
        if (last) {
            return (int)this.list.stream().filter(v2 -> (double)v2.longValue() >= start2 && (double)v2.longValue() <= end).count();
        }
        return (int)this.list.stream().filter(v2 -> (double)v2.longValue() >= start2 && (double)v2.longValue() < end).count();
    }
}

