/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.exploration.common;

import com.csvreader.CsvReader;
import com.csvreader.CsvWriter;
import com.datastax.data.exploration.biz.datatable.DataType;
import com.datastax.data.exploration.common.FileUrl;
import com.datastax.data.exploration.util.CommonUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.spark.sql.Row;
import org.javatuples.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataOperator {
    private static final Logger logger = LoggerFactory.getLogger(DataOperator.class);

    private static void checkPath(String fileAddress) {
        File path = new File(fileAddress).getParentFile();
        if (!path.exists()) {
            path.mkdirs();
        }
    }

    public static void writeDataAndType(String id, String[] columns, List<Row> listRow) {
        DataOperator.writeEntireData(id, listRow);
        DataOperator.writeType(id, columns, DataOperator.typeJudgment(listRow, columns.length));
    }

    private static void writeEntireData(String id, List<Row> listRow) {
        String fileAddress = FileUrl.entireData(id);
        DataOperator.checkPath(fileAddress);
        if (listRow != null && listRow.size() > 0) {
            int columnSize = listRow.get(0).size();
            CsvWriter csvWriter = new CsvWriter(fileAddress, ',', Charset.forName("UTF-8"));
            try {
                for (Row row : listRow) {
                    String[] rowData = new String[columnSize];
                    for (int i2 = 0; i2 < columnSize; ++i2) {
                        rowData[i2] = row.getString(i2);
                    }
                    csvWriter.writeRecord(rowData);
                }
                csvWriter.close();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
    }

    public static void writeExactData(String id, List<String[]> listRow) {
        DataOperator.writeData(listRow, FileUrl.exactData(id));
    }

    public static void writeErrorData(String id, List<String[]> listRow) {
        DataOperator.writeData(listRow, FileUrl.errorData(id));
    }

    private static void writeData(List<String[]> listRow, String fileAddress) {
        DataOperator.checkPath(fileAddress);
        CsvWriter csvWriter = new CsvWriter(fileAddress, ',', Charset.forName("UTF-8"));
        try {
            for (String[] row : listRow) {
                csvWriter.writeRecord(row);
            }
            csvWriter.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    private static List<String[]> readData(String fileAddress) {
        ArrayList<String[]> csvList = new ArrayList<String[]>();
        try {
            CsvReader reader = new CsvReader(fileAddress, ',', Charset.forName("UTF-8"));
            while (reader.readRecord()) {
                csvList.add(reader.getValues());
            }
            reader.close();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
        }
        return csvList;
    }

    public static String[] readHeaders(String id) {
        List<String> lines;
        File typeFile = new File(FileUrl.type(id));
        if (!typeFile.exists()) {
            logger.info("type file is not exist!");
        }
        if ((lines = DataOperator.readLines(typeFile)).size() == 2) {
            return lines.get(0).split(";");
        }
        logger.info("read type file error!");
        return null;
    }

    public static List<String[]> readEntireData(String id) {
        return DataOperator.readData(FileUrl.entireData(id));
    }

    public static List<String[]> readExactData(String id) {
        return DataOperator.readData(FileUrl.exactData(id));
    }

    public static List<String[]> readErrorData(String id) {
        return DataOperator.readData(FileUrl.errorData(id));
    }

    public static void writeTitle(String id, String title) {
        String fileAddress = FileUrl.title(id);
        DataOperator.checkPath(fileAddress);
        DataOperator.writeFile(new File(fileAddress), title);
    }

    public static String readTitle(String id) {
        String title = null;
        try {
            File file = new File(FileUrl.title(id));
            if (file.exists() && file.isFile()) {
                title = FileUtils.readFileToString((File)file, (String)"utf8");
            } else {
                logger.info("title file is not exist!");
            }
        }
        catch (IOException e2) {
            logger.error("Exception:read title file error!");
        }
        return title;
    }

    public static Map<String, String> readType(String id) {
        File typeFile = new File(FileUrl.type(id));
        if (!typeFile.exists()) {
            logger.info("type file is not exist!");
        }
        HashMap<String, String> colNamesAndtypes = new HashMap<String, String>();
        if (typeFile.exists() && typeFile.isFile()) {
            List<String> lines = DataOperator.readLines(typeFile);
            if (lines.size() == 2) {
                String[] columns = lines.get(0).split(";");
                String[] types = lines.get(1).split(";");
                for (int i2 = 0; i2 < columns.length; ++i2) {
                    colNamesAndtypes.put(columns[i2], types[i2]);
                }
            } else {
                logger.info("read type file error!");
            }
        }
        return colNamesAndtypes;
    }

    public static Pair<String[], DataType[]> readTitleAndType(String id) {
        List<String> lines = DataOperator.readLines(new File(FileUrl.type(id)));
        if (lines.size() != 2) {
            return null;
        }
        String[] titles = lines.get(0).split(";");
        String[] types = lines.get(1).split(";");
        DataType[] dateTypes = new DataType[types.length];
        for (int i2 = 0; i2 < types.length; ++i2) {
            dateTypes[i2] = DataType.getDataType(types[i2]);
        }
        return new Pair((Object)titles, (Object)dateTypes);
    }

    public static void writeType(String id, String[] columns, List<String> typeList) {
        String fileAddress = FileUrl.type(id);
        DataOperator.checkPath(fileAddress);
        StringBuffer typeStr = new StringBuffer();
        StringBuffer columnStr = new StringBuffer();
        if (typeList.size() == columns.length) {
            for (int i2 = 0; i2 < typeList.size(); ++i2) {
                typeStr.append(typeList.get(i2));
                columnStr.append(columns[i2]);
                if (i2 >= typeList.size() - 1) continue;
                columnStr.append(";");
                typeStr.append(";");
            }
        }
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(columnStr.toString());
        lines.add(typeStr.toString());
        DataOperator.writeLines(new File(fileAddress), lines);
    }

    private static List<String> typeJudgment(List<Row> listRow, int columnSize) {
        ArrayList<String> typeList = new ArrayList<String>();
        for (int i2 = 0; i2 < columnSize; ++i2) {
            int index = i2;
            List<String> listCol = listRow.parallelStream().map(e2 -> e2.getString(index)).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            long count = listCol.parallelStream().count();
            if (count < 2L) {
                typeList.add(DataType.TEXT.getName());
                continue;
            }
            if (count == 2L) {
                typeList.add(DataType.BINOMIAL.getName());
                continue;
            }
            if (count > 2L && count < 20L) {
                typeList.add(DataType.POLYNOMIAL.getName());
                continue;
            }
            typeList.add(DataOperator.parseType(listCol));
        }
        return typeList;
    }

    private static String parseType(List<String> listCol) {
        int i2;
        SimpleDateFormat formatDate = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat formatDateTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat formatTime = new SimpleDateFormat("HH:mm");
        for (i2 = 0; i2 < listCol.size(); ++i2) {
            try {
                Integer.parseInt(listCol.get(i2));
            }
            catch (Exception e2) {
                break;
            }
            if (i2 != listCol.size() - 1) continue;
            return DataType.INT.getName();
        }
        for (i2 = 0; i2 < listCol.size(); ++i2) {
            try {
                Double.parseDouble(listCol.get(i2));
            }
            catch (Exception e3) {
                break;
            }
            if (i2 != listCol.size() - 1) continue;
            return DataType.DECIMAL.getName();
        }
        for (i2 = 0; i2 < listCol.size(); ++i2) {
            try {
                formatDateTime.parse(listCol.get(i2));
            }
            catch (Exception e4) {
                break;
            }
            if (i2 != listCol.size() - 1) continue;
            return DataType.DATE_TIME.getName();
        }
        for (i2 = 0; i2 < listCol.size(); ++i2) {
            try {
                formatDate.parse(listCol.get(i2));
            }
            catch (Exception e5) {
                break;
            }
            if (i2 != listCol.size() - 1) continue;
            return DataType.DATE.getName();
        }
        for (i2 = 0; i2 < listCol.size(); ++i2) {
            try {
                formatTime.parse(listCol.get(i2));
            }
            catch (Exception e6) {
                break;
            }
            if (i2 != listCol.size() - 1) continue;
            return DataType.TIME.getName();
        }
        return DataType.TEXT.getName();
    }

    public static Pair<List<String[]>, List<String[]>> filterData(String id) {
        Map<String, String> typesMap = DataOperator.readType(id);
        List<String[]> listRow = DataOperator.readEntireData(id);
        String[] columns = DataOperator.readHeaders(id);
        ArrayList listErrorRow = new ArrayList();
        List listExactRow = listRow.parallelStream().filter(row -> {
            boolean matchFlag = true;
            for (String column : columns) {
                String col = row[CommonUtil.columnIndex(columns, column)];
                if (col != null && !col.trim().isEmpty()) continue;
                matchFlag = false;
                break;
            }
            if (!matchFlag) {
                listErrorRow.add(row);
            }
            return matchFlag;
        }).filter(row -> {
            String column;
            String col;
            boolean matchFlag = true;
            String[] stringArray = columns;
            int n2 = stringArray.length;
            for (int i2 = 0; i2 < n2 && (matchFlag = CommonUtil.matchType(col = row[CommonUtil.columnIndex(columns, column = stringArray[i2])], (String)typesMap.get(column))); ++i2) {
            }
            if (!matchFlag) {
                listErrorRow.add(row);
            }
            return matchFlag;
        }).collect(Collectors.toList());
        return Pair.with(listExactRow, listErrorRow);
    }

    public static String readStatistics(String fileName) {
        return DataOperator.readFile(new File(FileUrl.statistic(fileName)));
    }

    public static void writeStatistics(String fileName, String content) {
        DataOperator.writeFile(new File(FileUrl.statistic(fileName)), content);
    }

    public static Map<String, List<String>> readEntireDataWithHead(String id) {
        List<String[]> strings = DataOperator.readEntireData(id);
        String[] headers = DataOperator.readHeaders(id);
        if (strings == null || headers == null) {
            return null;
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (int i2 = 0; i2 < headers.length; ++i2) {
            int finalI = i2;
            map.put(headers[i2], strings.stream().map(e2 -> e2[finalI]).collect(Collectors.toList()));
        }
        return map;
    }

    public static Map<String, List<String>> readExactDataWithHead(String id) {
        List<String[]> strings = DataOperator.readExactData(id);
        String[] headers = DataOperator.readHeaders(id);
        if (strings == null || headers == null) {
            return null;
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (int i2 = 0; i2 < headers.length; ++i2) {
            int finalI = i2;
            map.put(headers[i2], strings.stream().map(e2 -> e2[finalI]).collect(Collectors.toList()));
        }
        return map;
    }

    public static void writeReport(String id, List<String> lines) {
        DataOperator.writeLines(new File(FileUrl.report(id)), lines);
    }

    public static List<String> readReport(String id) {
        return DataOperator.readLines(new File(FileUrl.report(id)));
    }

    private static void writeFile(File file, String content) {
        try {
            FileUtils.writeStringToFile((File)file, (String)content, (String)"UTF-8");
        }
        catch (IOException e2) {
            logger.error("Exception:write title file error!", (Throwable)e2);
        }
    }

    private static void writeLines(File file, List<String> lines) {
        try {
            FileUtils.writeLines((File)file, (String)"UTF-8", lines);
        }
        catch (IOException e2) {
            logger.error("Exception:write title file error!", (Throwable)e2);
        }
    }

    private static String readFile(File file) {
        try {
            return FileUtils.readFileToString((File)file, (String)"UTF-8");
        }
        catch (IOException e2) {
            logger.error("Exception:read type file error", (Throwable)e2);
            return "";
        }
    }

    private static List<String> readLines(File file) {
        try {
            return FileUtils.readLines((File)file, (String)"UTF-8");
        }
        catch (IOException e2) {
            logger.error("Exception:read type file error", (Throwable)e2);
            return new ArrayList<String>();
        }
    }

    private static String parseIdUrl(Long userId, String id) {
        String[] ids = id.split("-");
        StringBuffer idPath = new StringBuffer("");
        idPath.append(File.separatorChar);
        idPath.append(userId);
        for (String str : ids) {
            idPath.append(File.separatorChar);
            idPath.append(str);
        }
        return idPath.toString();
    }
}

