/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.exploration.common;

import com.datastax.data.exploration.biz.datatable.DataTable;
import com.datastax.data.exploration.biz.datatable.DataType;
import com.datastax.data.exploration.biz.datatable.column.DataColumn;
import java.util.List;
import java.util.stream.Collectors;
import org.javatuples.Pair;

public class DataTypeHandler {
    public static Pair<List<String>, List<String>> continuousDiscrete(DataTable table) {
        return new Pair(DataTypeHandler.continuous(table), DataTypeHandler.discrete(table));
    }

    public static Pair<List<String>, List<String>> numericDiscrete(DataTable table) {
        return new Pair(DataTypeHandler.numeric(table), DataTypeHandler.discrete(table));
    }

    private static List<String> numeric(DataTable table) {
        return table.getColumns().stream().filter(column -> DataType.INT.equals((Object)column.getType()) || DataType.DECIMAL.equals((Object)column.getType())).map(DataColumn::getColumnName).collect(Collectors.toList());
    }

    public static List<String> continuous(DataTable table) {
        return table.getColumns().stream().filter(column -> DataType.INT.equals((Object)column.getType()) || DataType.DECIMAL.equals((Object)column.getType()) || DataType.DATE_TIME.equals((Object)column.getType()) || DataType.DATE.equals((Object)column.getType()) || DataType.TIME.equals((Object)column.getType())).map(DataColumn::getColumnName).collect(Collectors.toList());
    }

    public static List<String> discrete(DataTable table) {
        return table.getColumns().stream().filter(column -> DataType.BINOMIAL.equals((Object)column.getType()) || DataType.POLYNOMIAL.equals((Object)column.getType())).map(DataColumn::getColumnName).collect(Collectors.toList());
    }

    public static List<String> noText(DataTable table) {
        return table.getColumns().stream().filter(column -> !DataType.TEXT.equals((Object)column.getType())).map(DataColumn::getColumnName).collect(Collectors.toList());
    }

    public static boolean isDateTypeName(String name) {
        return DataType.DATE_TIME.getName().equals(name) || DataType.DATE.getName().equals(name) || DataType.TIME.getName().equals(name);
    }

    public static List<String> getNumericType(DataTable table) {
        return table.getColumns().stream().filter(column -> DataType.DECIMAL.equals((Object)column.getType()) || DataType.INT.equals((Object)column.getType())).map(DataColumn::getColumnName).collect(Collectors.toList());
    }
}

