/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.exploration.common;

import com.csvreader.CsvReader;
import com.datastax.data.exploration.biz.datatable.DataTable;
import com.datastax.data.exploration.biz.datatable.DataType;
import com.datastax.data.exploration.common.DataOperator;
import com.datastax.data.exploration.common.FileUrl;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.javatuples.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class File2DataTable {
    private static final Logger logger = LoggerFactory.getLogger(File2DataTable.class);

    public static DataTable entireTable(String id) {
        return File2DataTable.table(id, FileUrl.entireData(id));
    }

    public static DataTable exactTable(String id) {
        return File2DataTable.table(id, FileUrl.exactData(id));
    }

    public static DataTable errorTable(String id) {
        return File2DataTable.table(id, FileUrl.errorData(id));
    }

    private static DataTable table(String id, String filePath) {
        DataTable table = File2DataTable.tableSchema(id);
        if (table == null) {
            return null;
        }
        List<String[]> data = File2DataTable.data(filePath);
        if (data == null) {
            return null;
        }
        try {
            for (String[] line : data) {
                table.getRows().add(line);
            }
        }
        catch (Exception e2) {
            logger.error(e2.getMessage(), (Throwable)e2);
        }
        return table;
    }

    public static DataTable tableSchema(String id) {
        DataTable table = new DataTable();
        table.setTableName(id);
        Pair<String[], DataType[]> headers = DataOperator.readTitleAndType(id);
        if (headers == null) {
            return null;
        }
        String[] titles = (String[])headers.getValue0();
        DataType[] dateTypes = (DataType[])headers.getValue1();
        for (int i2 = 0; i2 < titles.length; ++i2) {
            table.getColumns().add(titles[i2], dateTypes[i2]);
        }
        return table;
    }

    private static List<String[]> data(String filePath) {
        File file = new File(filePath);
        ArrayList<String[]> data = new ArrayList<String[]>();
        try {
            if (!file.exists()) {
                logger.info(file.getCanonicalPath() + " data file is not exist!");
                return null;
            }
            CsvReader reader = new CsvReader(filePath, ',', Charset.forName("UTF-8"));
            while (reader.readRecord()) {
                data.add(reader.getValues());
            }
            reader.close();
        }
        catch (Exception e2) {
            logger.error(e2.getMessage(), (Throwable)e2);
        }
        return data;
    }
}

