/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.exploration.common;

import java.util.List;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.javatuples.Pair;
import org.javatuples.Triplet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkOperator {
    private static final Logger logger = LoggerFactory.getLogger(SparkOperator.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Triplet<Long, String[], List<Row>> getData(boolean title, String address, long limit) {
        SparkSession sparkSession = SparkSession.builder().appName("datastax-insight").master("local[*]").getOrCreate();
        try {
            Dataset<Row> dataset = SparkOperator.getDataset(sparkSession, title, address);
            long count = dataset.count();
            if (count < limit) {
                String[] columns = dataset.columns();
                List listRow = dataset.collectAsList();
                Triplet triplet = new Triplet((Object)count, (Object)columns, (Object)listRow);
                return triplet;
            }
            Triplet triplet = new Triplet((Object)count, null, null);
            return triplet;
        }
        catch (Exception e2) {
            Triplet triplet = new Triplet((Object)0L, null, null);
            return triplet;
        }
        finally {
            sparkSession.stop();
            logger.info(sparkSession.hashCode() + " sparkSession stop!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pair<String[], List<Row>> sample(boolean title, String address, int size) {
        SparkSession sparkSession = SparkSession.builder().appName("datastax-insight").master("local[*]").getOrCreate();
        try {
            Dataset<Row> dataset = SparkOperator.getDataset(sparkSession, title, address);
            String[] columns = dataset.columns();
            List listRow = dataset.javaRDD().takeSample(false, size);
            Pair pair = new Pair((Object)columns, (Object)listRow);
            return pair;
        }
        catch (Exception e2) {
            Pair pair = new Pair(null, null);
            return pair;
        }
        finally {
            sparkSession.stop();
            logger.info(sparkSession.hashCode() + " sparkSession stop!");
        }
    }

    private static Dataset<Row> getDataset(SparkSession sparkSession, boolean title, String address) {
        Dataset dataset = title ? sparkSession.read().option("header", "true").csv(address) : sparkSession.read().csv(address);
        if (dataset == null) {
            logger.info("read dataset error!");
        }
        return dataset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pair<String[], List<Row>> getData(boolean title, String address) {
        SparkSession sparkSession = SparkSession.builder().appName("datastax-insight").master("local[*]").getOrCreate();
        try {
            Dataset<Row> dataset = SparkOperator.getDataset(sparkSession, title, address);
            String[] columns = dataset.columns();
            List listRow = dataset.collectAsList();
            Pair pair = new Pair((Object)columns, (Object)listRow);
            return pair;
        }
        catch (Exception e2) {
            Pair pair = new Pair(null, null);
            return pair;
        }
        finally {
            sparkSession.stop();
            logger.info(sparkSession.hashCode() + " sparkSession stop!");
        }
    }
}

