/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.exploration.service.chart.impl;

import com.datastax.data.exploration.biz.datatable.DataTable;
import com.datastax.data.exploration.biz.datatable.column.DataColumn;
import com.datastax.data.exploration.biz.stat.StatInfo;
import com.datastax.data.exploration.biz.stat.bar.BarStat;
import com.datastax.data.exploration.biz.stat.executor.NomialExecutor;
import com.datastax.data.exploration.biz.stat.executor.StatExecutor;
import com.datastax.data.exploration.biz.stat.executor.StatExecutorFactory;
import com.datastax.data.exploration.common.DataTypeHandler;
import com.datastax.data.exploration.common.File2DataTable;
import com.datastax.data.exploration.service.chart.BarService;
import java.util.List;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class BarServiceImpl
implements BarService {
    private static final Logger logger = LogManager.getLogger(BarServiceImpl.class);

    @Override
    public List<String> getSimpleHistogramColumns(String id) {
        return DataTypeHandler.discrete(File2DataTable.tableSchema(id));
    }

    @Override
    public StatInfo stat(String id, String col) {
        StatInfo info = new StatInfo();
        DataTable table = File2DataTable.entireTable(id);
        DataColumn column = table.getColumns().getColumn(col);
        info.setType(column.getType().getName());
        StatExecutor executor = StatExecutorFactory.createStatExecutor(column);
        if (executor instanceof NomialExecutor) {
            BarStat stat = ((NomialExecutor)executor).getBar();
            info.setData(stat.getStat());
        }
        return info;
    }
}

