/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.exploration.service.chart.impl;

import com.datastax.data.exploration.biz.datatable.DataTable;
import com.datastax.data.exploration.biz.datatable.column.DataColumn;
import com.datastax.data.exploration.biz.datatable.column.DateColumn;
import com.datastax.data.exploration.biz.datatable.column.DateTimeColumn;
import com.datastax.data.exploration.biz.datatable.column.TimeColumn;
import com.datastax.data.exploration.common.DataTypeHandler;
import com.datastax.data.exploration.common.File2DataTable;
import com.datastax.data.exploration.dto.BoxPlotData;
import com.datastax.data.exploration.service.chart.BoxPlotService;
import java.util.List;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class BoxPlotServiceImpl
implements BoxPlotService {
    private static final Logger logger = LogManager.getLogger(BoxPlotServiceImpl.class);

    @Override
    public BoxPlotData getDataAll(String id) {
        BoxPlotData box = new BoxPlotData();
        DataTable table = File2DataTable.entireTable(id);
        List<String> names = DataTypeHandler.continuous(table);
        for (String name : names) {
            DataColumn column = table.getColumns().getColumn(name);
            String format = null;
            if (column instanceof DateTimeColumn) {
                format = DateTimeColumn.format.toPattern();
            } else if (column instanceof DateColumn) {
                format = DateColumn.format.toPattern();
            } else if (column instanceof TimeColumn) {
                format = TimeColumn.format.toPattern();
            }
            box.put(name, column.getType().getName(), format, column.getNotNullValues());
        }
        return box;
    }

    @Override
    public List<String> getBoxplotColumns(String id) {
        return DataTypeHandler.continuous(File2DataTable.tableSchema(id));
    }
}

