/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.exploration.service.chart.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.datastax.data.exploration.biz.datatable.DataTable;
import com.datastax.data.exploration.biz.datatable.DataType;
import com.datastax.data.exploration.biz.datatable.column.DataColumn;
import com.datastax.data.exploration.common.DataTypeHandler;
import com.datastax.data.exploration.common.File2DataTable;
import com.datastax.data.exploration.service.chart.BrokenLineService;
import com.datastax.data.exploration.util.CommonUtil;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service(value="brokenLineService")
public class BrokenLineServiceImpl
implements BrokenLineService {
    @Override
    public JSONObject brokenLineInit(String id) {
        List<String> axisX = DataTypeHandler.noText(File2DataTable.tableSchema(id));
        if (axisX.size() == 0) {
            axisX.add("NONE");
        }
        JSONObject json = new JSONObject();
        json.put("axisX", (Object)axisX);
        json.put("axisY", (Object)axisX);
        return json;
    }

    @Override
    public JSONObject brokenLineValue(String id, String axisX, String axisYs) {
        List<String> axisYList = JSONArray.parseArray(axisYs, String.class);
        if (axisX.equals("NONE")) {
            return new JSONObject();
        }
        DataTable table = File2DataTable.exactTable(id);
        JSONObject jsonX = BrokenLineServiceImpl.getValue(table.getColumns().getColumn(axisX), axisX);
        ArrayList<JSONObject> jsonYs = new ArrayList<JSONObject>();
        for (String axisY : axisYList) {
            jsonYs.add(BrokenLineServiceImpl.getValue(table.getColumns().getColumn(axisY), axisY));
        }
        JSONObject json = new JSONObject();
        json.put("axisX", (Object)jsonX);
        json.put("axisY", (Object)jsonYs);
        return json;
    }

    private static JSONObject getValue(DataColumn dataColumn, String column) {
        DataType dataType = dataColumn.getType();
        JSONObject json = new JSONObject();
        json.put("name", (Object)column);
        json.put("type", (Object)dataType.getName());
        json.put("format", (Object)CommonUtil.getFormat(dataType));
        json.put("data", (Object)dataColumn.getNotNullValues());
        return json;
    }
}

