/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.exploration.service.chart.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.datastax.data.exploration.biz.corrcoef.Pearson;
import com.datastax.data.exploration.biz.corrcoef.Spearman;
import com.datastax.data.exploration.biz.datatable.DataRow;
import com.datastax.data.exploration.biz.datatable.DataTable;
import com.datastax.data.exploration.common.DataTypeHandler;
import com.datastax.data.exploration.common.File2DataTable;
import com.datastax.data.exploration.service.chart.CorrelationService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.math3.linear.RealMatrix;
import org.javatuples.Quintet;
import org.springframework.stereotype.Service;

@Service
public class CorrelationServiceImpl
implements CorrelationService {
    private static Quintet<String, String, Integer, Integer, String> PEARSON = new Quintet((Object)"pearson", (Object)"Pearson\u76f8\u5173\u7cfb\u6570", (Object)0, (Object)100, (Object)"continuous");
    private static Quintet<String, String, Integer, Integer, String> SPEARMAN = new Quintet((Object)"spearman", (Object)"Spearman\u79e9\u76f8\u5173\u7cfb\u6570", (Object)-100, (Object)100, (Object)"continuous");
    private static List<Quintet<String, String, Integer, Integer, String>> CORRELATION = new ArrayList<Quintet<String, String, Integer, Integer, String>>();

    @Override
    public JSONArray init(String id) {
        DataTable table = File2DataTable.tableSchema(id);
        JSONArray jsonArray = new JSONArray();
        for (Quintet<String, String, Integer, Integer, String> quintet : CORRELATION) {
            JSONObject node = new JSONObject();
            JSONObject jsonObject = new JSONObject();
            node.put((String)quintet.getValue0(), (Object)jsonObject);
            jsonObject.put("text", quintet.getValue1());
            jsonObject.put("min", quintet.getValue2());
            jsonObject.put("max", quintet.getValue3());
            JSONArray value = new JSONArray();
            jsonObject.put("value", (Object)value);
            String type = (String)quintet.getValue4();
            if ("continuous".equals(type)) {
                List<String> continuous = DataTypeHandler.continuous(table);
                value.addAll((Collection<? extends Object>)continuous);
            }
            jsonArray.add(node);
        }
        return jsonArray;
    }

    @Override
    public JSONObject select(String id, String type, String[] axis) {
        JSONObject jsonObject = new JSONObject();
        JSONArray names = new JSONArray();
        jsonObject.put("name", (Object)names);
        Collections.addAll(names, axis);
        JSONArray data = new JSONArray();
        jsonObject.put("data", (Object)data);
        DataTable table = File2DataTable.exactTable(id);
        double[][] source = new double[table.getRows().size()][axis.length];
        for (int i2 = 0; i2 < table.getRows().size(); ++i2) {
            for (int j2 = 0; j2 < axis.length; ++j2) {
                Object value = ((DataRow)table.getRows().get(i2)).getValue(axis[j2]);
                if (value instanceof Date) {
                    source[i2][j2] = ((Date)value).getTime();
                    continue;
                }
                if (!(value instanceof Number)) continue;
                source[i2][j2] = ((Number)value).doubleValue();
            }
        }
        if (type.equals("pearson")) {
            RealMatrix matrix = new Pearson(source).correlationMatrix();
            this.matrix(matrix, data, (Integer)PEARSON.getValue3());
        } else if (type.equals("spearman")) {
            RealMatrix matrix = new Spearman(source).correlationMatrix();
            this.matrix(matrix, data, (Integer)SPEARMAN.getValue3());
        }
        return jsonObject;
    }

    private void matrix(RealMatrix matrix, JSONArray data, Integer num) {
        int row = matrix.getRowDimension();
        int column = matrix.getColumnDimension();
        for (int i2 = 0; i2 < row; ++i2) {
            for (int j2 = 0; j2 < column; ++j2) {
                JSONArray array = new JSONArray();
                array.add((Object)i2);
                array.add((Object)j2);
                array.add((Object)((int)(matrix.getEntry(i2, j2) * (double)num.intValue())));
                data.add(array);
            }
        }
    }

    static {
        CORRELATION.add(PEARSON);
        CORRELATION.add(SPEARMAN);
    }
}

