/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.exploration.service.chart.impl;

import com.datastax.data.exploration.biz.datatable.DataTable;
import com.datastax.data.exploration.biz.datatable.column.NomialColumn;
import com.datastax.data.exploration.biz.stat.Cross;
import com.datastax.data.exploration.common.File2DataTable;
import com.datastax.data.exploration.dto.dataChart.stackedBar.Crosstab;
import com.datastax.data.exploration.service.chart.CrosstabService;
import java.util.List;
import java.util.Map;
import org.javatuples.Pair;
import org.springframework.stereotype.Service;

@Service(value="crosstabService")
public class CrosstabServiceImpl
implements CrosstabService {
    private static final String EMPTY = "";

    @Override
    public Crosstab crosstabData(String id, String group, String stack) {
        if ("NONE".equals(group) || "NONE".equals(stack)) {
            return new Crosstab();
        }
        DataTable table = File2DataTable.exactTable(id);
        List<String> groupSubs = ((NomialColumn)table.getColumns().getColumn(group)).distinct();
        List<String> stackSubs = ((NomialColumn)table.getColumns().getColumn(stack)).distinct();
        Pair<List<List<Long>>, List<Long>> pair = Cross.getCount(table, group, stack);
        List groupCounts = (List)pair.getValue0();
        Pair<Long, List<Long>> pairTotal = Cross.getCountTotals(groupCounts);
        Map<Cross.Func, String> map = Cross.getFuncs(group, stack);
        String[] summary2 = Cross.getSummary(id);
        Crosstab.ModuleData contentModule = Cross.getContentModule(map, group, groupSubs, pair, pairTotal);
        Crosstab.GroupData totalModule = Cross.getTotalModule(map, (List)pairTotal.getValue1(), (Long)pairTotal.getValue0());
        List<Crosstab.ChiSquare> chiSquares = Cross.getChiSquare(groupCounts, (Long)pairTotal.getValue0());
        if (group.equals(stack)) {
            stackSubs = stackSubs.subList(0, 1);
        }
        stackSubs.add("\u5408\u8ba1");
        Crosstab crosstab = new Crosstab.Builder().summary(summary2).stack(stack).stackSubs(stackSubs).content(contentModule).total(totalModule).chiSquare(chiSquares).build();
        return crosstab;
    }
}

