/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.exploration.service.chart.impl;

import com.datastax.data.exploration.biz.datatable.DataTable;
import com.datastax.data.exploration.biz.datatable.column.DataColumn;
import com.datastax.data.exploration.biz.stat.StatInfo;
import com.datastax.data.exploration.biz.stat.executor.NumberExecutor;
import com.datastax.data.exploration.biz.stat.executor.StatExecutor;
import com.datastax.data.exploration.biz.stat.executor.StatExecutorFactory;
import com.datastax.data.exploration.biz.stat.executor.TimestampExecutor;
import com.datastax.data.exploration.biz.stat.histogram.HistogramStat;
import com.datastax.data.exploration.common.DataTypeHandler;
import com.datastax.data.exploration.common.File2DataTable;
import com.datastax.data.exploration.service.chart.HistogramService;
import java.util.List;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class HistogramServiceImpl
implements HistogramService {
    private static final Logger logger = LogManager.getLogger(HistogramServiceImpl.class);

    @Override
    public List<String> getFrequencyHistogramColumns(String id) {
        return DataTypeHandler.continuous(File2DataTable.tableSchema(id));
    }

    @Override
    public StatInfo stat(String id, String col, Integer groupNum) {
        StatInfo info = new StatInfo();
        DataTable table = File2DataTable.entireTable(id);
        DataColumn column = table.getColumns().getColumn(col);
        info.setType(column.getType().getName());
        StatExecutor executor = StatExecutorFactory.createStatExecutor(column);
        if (executor instanceof NumberExecutor) {
            HistogramStat histogram = ((NumberExecutor)executor).getHistogram();
            info.setData(histogram.stage(groupNum));
        } else if (executor instanceof TimestampExecutor) {
            HistogramStat histogram = ((TimestampExecutor)executor).getHistogram();
            info.setData(histogram.stage(groupNum));
            info.setFormat(((TimestampExecutor)executor).format());
        }
        return info;
    }
}

