/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.exploration.service.chart.impl;

import com.alibaba.fastjson.JSONObject;
import com.datastax.data.exploration.biz.datatable.DataTable;
import com.datastax.data.exploration.biz.datatable.column.NomialColumn;
import com.datastax.data.exploration.biz.stat.Pareto;
import com.datastax.data.exploration.common.DataTypeHandler;
import com.datastax.data.exploration.common.File2DataTable;
import com.datastax.data.exploration.service.chart.ParetoService;
import java.util.ArrayList;
import java.util.List;
import org.javatuples.Pair;
import org.springframework.stereotype.Service;

@Service(value="paretoService")
public class ParetoServiceImpl
implements ParetoService {
    @Override
    public JSONObject paretoInit(String id) {
        Pair<List<String>, List<String>> pair = DataTypeHandler.numericDiscrete(File2DataTable.tableSchema(id));
        List listVal = (List)pair.getValue0();
        List listGroup = (List)pair.getValue1();
        listVal.addAll(listGroup);
        if (listGroup.size() == 0) {
            listGroup.add("NONE");
        }
        if (listVal.size() == 0) {
            listVal.add("NONE");
        }
        DataTable table = File2DataTable.exactTable(id);
        ArrayList<JSONObject> valSubs = new ArrayList<JSONObject>();
        for (String val : listVal) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("name", (Object)val);
            if (listGroup.contains(val)) {
                NomialColumn nomialColumn = (NomialColumn)table.getColumns().getColumn(val);
                jsonObject.put("subs", (Object)nomialColumn.distinct());
            } else {
                String[] vals = new String[]{"NONE"};
                jsonObject.put("subs", (Object)vals);
            }
            valSubs.add(jsonObject);
        }
        JSONObject json = new JSONObject();
        json.put("groups", (Object)listGroup);
        json.put("vals", (Object)listVal);
        json.put("valSubs", (Object)valSubs);
        return json;
    }

    @Override
    public List<JSONObject> paretoSelect(String id, String group, String val, String valSub) {
        if ("NONE".equals(group) || "NONE".equals(val)) {
            return new ArrayList<JSONObject>();
        }
        return Pareto.operator(id, group, val, valSub);
    }
}

