/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.exploration.service.chart.impl;

import com.alibaba.fastjson.JSONObject;
import com.datastax.data.exploration.biz.datatable.DataTable;
import com.datastax.data.exploration.biz.datatable.DataType;
import com.datastax.data.exploration.common.DataTypeHandler;
import com.datastax.data.exploration.common.File2DataTable;
import com.datastax.data.exploration.service.chart.Scatter3DService;
import com.datastax.data.exploration.service.chart.impl.ScatterServiceImpl;
import com.datastax.data.exploration.util.CommonUtil;
import java.util.List;
import org.javatuples.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="scatter3DService")
public class Scatter3DServiceImpl
implements Scatter3DService {
    private static final Logger logger = LoggerFactory.getLogger(ScatterServiceImpl.class);

    @Override
    public JSONObject scatter3DInit(String id) {
        List<String> axisX = DataTypeHandler.noText(File2DataTable.tableSchema(id));
        if (axisX.size() == 0) {
            axisX.add("NONE");
        }
        JSONObject json = new JSONObject();
        json.put("axisX", (Object)axisX);
        json.put("axisY", (Object)axisX);
        json.put("axisZ", (Object)axisX);
        json.put("color", (Object)axisX);
        return json;
    }

    @Override
    public JSONObject scatter3DSelect(String id, String axisX, String axisY, String axisZ, String color) {
        DataTable table = File2DataTable.exactTable(id);
        String[] type = new String[]{(String)this.typeAndformat(table, axisX).getValue0(), (String)this.typeAndformat(table, axisY).getValue0(), (String)this.typeAndformat(table, axisZ).getValue0(), (String)this.typeAndformat(table, color).getValue0()};
        String[] format = new String[]{(String)this.typeAndformat(table, axisX).getValue1(), (String)this.typeAndformat(table, axisY).getValue1(), (String)this.typeAndformat(table, axisZ).getValue1(), (String)this.typeAndformat(table, color).getValue1()};
        JSONObject json = new JSONObject();
        json.put("data", (Object)table.getRows().dataDimen4(axisX, axisY, axisZ, color));
        json.put("type", (Object)type);
        json.put("format", (Object)format);
        return json;
    }

    private Pair<String, String> typeAndformat(DataTable table, String column) {
        DataType dataType = table.getColumns().getColumn(column).getType();
        return new Pair((Object)dataType.getName(), (Object)CommonUtil.getFormat(dataType));
    }
}

