/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.exploration.service.chart.impl;

import com.alibaba.fastjson.JSONObject;
import com.datastax.data.exploration.biz.datatable.DataTable;
import com.datastax.data.exploration.biz.datatable.DataType;
import com.datastax.data.exploration.common.DataTypeHandler;
import com.datastax.data.exploration.common.File2DataTable;
import com.datastax.data.exploration.service.chart.ScatterService;
import com.datastax.data.exploration.util.CommonUtil;
import java.util.List;
import org.javatuples.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="scatterService")
public class ScatterServiceImpl
implements ScatterService {
    private static final Logger logger = LoggerFactory.getLogger(ScatterServiceImpl.class);
    private static final String labelPreffix = "vector-";

    @Override
    public JSONObject scatterInit(String id) {
        List<String> axisX = DataTypeHandler.noText(File2DataTable.tableSchema(id));
        if (axisX.size() == 0) {
            axisX.add("NONE");
        }
        JSONObject json = new JSONObject();
        json.put("axisX", (Object)axisX);
        json.put("axisY", (Object)axisX);
        json.put("color", (Object)axisX);
        return json;
    }

    @Override
    public JSONObject scatterSelect(String id, String axisX, String axisY, String color) {
        DataTable table = File2DataTable.exactTable(id);
        String[] type = new String[]{(String)this.typeAndformat(table, axisX).getValue0(), (String)this.typeAndformat(table, axisY).getValue0(), (String)this.typeAndformat(table, color).getValue0()};
        String[] format = new String[]{(String)this.typeAndformat(table, axisX).getValue1(), (String)this.typeAndformat(table, axisY).getValue1(), (String)this.typeAndformat(table, color).getValue1()};
        JSONObject json = new JSONObject();
        json.put("data", (Object)table.getRows().dataDimen3(axisX, axisY, color));
        json.put("type", (Object)type);
        json.put("format", (Object)format);
        return json;
    }

    private Pair<String, String> typeAndformat(DataTable table, String column) {
        DataType dataType = table.getColumns().getColumn(column).getType();
        return new Pair((Object)dataType.getName(), (Object)CommonUtil.getFormat(dataType));
    }

    @Override
    public List<String> getOutlierInitColumns(String id) {
        return DataTypeHandler.getNumericType(File2DataTable.tableSchema(id));
    }
}

