/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.exploration.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.datastax.data.exploration.common.DataOperator;
import com.datastax.data.exploration.service.DataExhibitionService;
import com.datastax.data.exploration.util.CommonUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service(value="dataExhibitionService")
public class DataExhibitionServiceImpl
implements DataExhibitionService {
    @Override
    public JSONObject exhibitData(String id, String column, String mode) {
        Map<String, String> typesMap = DataOperator.readType(id);
        String[] columns = DataOperator.readHeaders(id);
        List<Object> listRow = DataOperator.readEntireData(id);
        if (!column.equals("all")) {
            int columnIndex = CommonUtil.columnIndex(columns, column);
            if (mode.equals("missing")) {
                listRow = listRow.parallelStream().filter(row -> row[columnIndex] == null || row[columnIndex].trim().isEmpty()).collect(Collectors.toList());
            }
            if (mode.equals("noMissing")) {
                listRow = listRow.parallelStream().filter(row -> row[columnIndex] != null && !row[columnIndex].trim().isEmpty()).collect(Collectors.toList());
            }
            if (mode.equals("error")) {
                listRow = DataOperator.readErrorData(id);
                listRow = listRow.parallelStream().filter(row -> row[columnIndex] != null && !row[columnIndex].trim().isEmpty()).filter(row -> !CommonUtil.matchType(row[columnIndex], (String)typesMap.get(column))).collect(Collectors.toList());
            }
        }
        if ("all".equals(column)) {
            if (mode.equals("missing")) {
                listRow = listRow.parallelStream().filter(row -> {
                    boolean matchFlag = false;
                    for (String colName : columns) {
                        String col = row[CommonUtil.columnIndex(columns, colName)];
                        if (col != null && !col.trim().isEmpty()) continue;
                        matchFlag = true;
                        break;
                    }
                    return matchFlag;
                }).collect(Collectors.toList());
            }
            if (mode.equals("noMissing")) {
                listRow = listRow.parallelStream().filter(row -> {
                    boolean matchFlag = true;
                    for (String colName : columns) {
                        String col = row[CommonUtil.columnIndex(columns, colName)];
                        if (col != null && !col.trim().isEmpty()) continue;
                        matchFlag = false;
                        break;
                    }
                    return matchFlag;
                }).collect(Collectors.toList());
            }
            if (mode.equals("error")) {
                listRow = DataOperator.readErrorData(id).parallelStream().filter(row -> {
                    boolean matchFlag = false;
                    for (String colName : columns) {
                        String col = row[CommonUtil.columnIndex(columns, colName)];
                        if (col == null || col.trim().isEmpty()) continue;
                        matchFlag = true;
                        break;
                    }
                    return matchFlag;
                }).collect(Collectors.toList());
            }
        }
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        for (String colName : columns) {
            List dataList = listRow.parallelStream().map(row -> {
                String obj = row[CommonUtil.columnIndex(columns, colName)];
                if (obj == null) {
                    obj = "";
                }
                return obj;
            }).collect(Collectors.toList());
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("name", (Object)colName);
            jsonObject.put("type", (Object)typesMap.get(colName));
            jsonObject.put("data", (Object)dataList);
            list.add(jsonObject);
        }
        JSONObject json = new JSONObject();
        json.put("id", (Object)id);
        json.put("list", (Object)list);
        return json;
    }
}

