/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.exploration.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.datastax.data.exploration.common.DataOperator;
import com.datastax.data.exploration.service.PersistentDataService;
import com.datastax.data.exploration.util.CommonUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="persistentDataService")
public class PersistentDataServiceImpl
implements PersistentDataService {
    private static final Logger logger = LoggerFactory.getLogger(PersistentDataServiceImpl.class);

    @Override
    public void setDataType(String idUrl, JSONObject jsonObject) {
        ArrayList<String> listTypes = new ArrayList<String>();
        ArrayList<String> listColumns = new ArrayList<String>();
        JSONArray jsonArrayData = JSONArray.parseArray(jsonObject.getString("list"));
        for (Object jsonObjectCol : jsonArrayData) {
            listColumns.add(JSONObject.parseObject(jsonObjectCol.toString()).getString("name"));
            listTypes.add(JSONObject.parseObject(jsonObjectCol.toString()).getString("type"));
        }
        DataOperator.writeType(idUrl, listColumns.toArray(new String[listColumns.size()]), listTypes);
    }

    @Override
    public JSONObject typeShow(String id) {
        List<String[]> listRow = DataOperator.readEntireData(id);
        String[] columns = DataOperator.readHeaders(id);
        Map<String, String> typesMap = DataOperator.readType(id);
        if (listRow.size() > 100) {
            listRow = listRow.subList(0, 100);
        }
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        for (String column : columns) {
            List dataList = listRow.parallelStream().map(row -> row[CommonUtil.columnIndex(columns, column)]).collect(Collectors.toList());
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("name", (Object)column);
            jsonObject.put("type", (Object)typesMap.get(column));
            jsonObject.put("data", (Object)dataList);
            list.add(jsonObject);
        }
        JSONObject json = new JSONObject();
        json.put("id", (Object)id);
        json.put("list", (Object)list);
        return json;
    }

    @Override
    public void filterErrorData(String id) {
        DataOperator.writeExactData(id, (List)DataOperator.filterData(id).getValue0());
        DataOperator.writeErrorData(id, (List)DataOperator.filterData(id).getValue1());
    }
}

