/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.exploration.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.datastax.data.exploration.biz.datatable.DataTable;
import com.datastax.data.exploration.biz.datatable.column.DataColumn;
import com.datastax.data.exploration.biz.stat.StatInfo;
import com.datastax.data.exploration.biz.stat.executor.StatExecutor;
import com.datastax.data.exploration.biz.stat.executor.StatExecutorFactory;
import com.datastax.data.exploration.common.DataOperator;
import com.datastax.data.exploration.common.File2DataTable;
import com.datastax.data.exploration.service.StatisticsService;
import java.util.ArrayList;
import org.springframework.stereotype.Service;

@Service
public class StatisticsServiceImpl
implements StatisticsService {
    @Override
    public void writeStat(String id) {
        String content = this.stat(id);
        DataOperator.writeStatistics(id, content);
    }

    @Override
    public String readStat(String id) {
        return DataOperator.readStatistics(id);
    }

    @Override
    public String stat(String id) {
        DataTable table = File2DataTable.entireTable(id);
        ArrayList<StatInfo> stats = new ArrayList<StatInfo>();
        for (DataColumn column : table.getColumns()) {
            StatExecutor executor = StatExecutorFactory.createStatExecutor(column);
            if (executor == null) continue;
            stats.add(executor.stat());
        }
        return JSONObject.toJSONString(stats);
    }
}

