/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.exploration.service.report.impl;

import com.datastax.data.exploration.biz.datatable.DataTable;
import com.datastax.data.exploration.biz.report.detector.Detector;
import com.datastax.data.exploration.biz.report.detector.error.ErrorDataDetector;
import com.datastax.data.exploration.biz.report.detector.miss.MissDataDetector;
import com.datastax.data.exploration.common.DataOperator;
import com.datastax.data.exploration.service.report.DetectService;
import java.util.ArrayList;
import org.springframework.stereotype.Service;

@Service
public class DetectServiceImpl
implements DetectService {
    @Override
    public void detect(DataTable table) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(this.detect(new MissDataDetector(), table, "miss.data"));
        lines.add(this.detect(new ErrorDataDetector(), table, "error.data"));
        DataOperator.writeReport(table.getTableName(), lines);
    }

    private String detect(Detector detector, DataTable table, String name) {
        return name + " = " + detector.detect(table);
    }
}

