/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.exploration.util;

import com.datastax.data.exploration.biz.datatable.DataType;
import java.text.SimpleDateFormat;

public class CommonUtil {
    public static int columnIndex(String[] columns, String searchColumn) {
        int index = -1;
        for (int i2 = 0; i2 < columns.length; ++i2) {
            if (!searchColumn.equals(columns[i2])) continue;
            index = i2;
            break;
        }
        return index;
    }

    public static int[] columnIndex(String[] columns, String[] searchColumn) {
        int[] positions = new int[searchColumn.length];
        block0: for (int i2 = 0; i2 < searchColumn.length; ++i2) {
            positions[i2] = -1;
            for (int j2 = 0; j2 < columns.length; ++j2) {
                if (!columns[j2].equals(searchColumn[i2])) continue;
                positions[i2] = j2;
                continue block0;
            }
        }
        return positions;
    }

    public static String getFormat(DataType type) {
        String format;
        switch (type) {
            case DATE_TIME: {
                format = "yyyy-MM-dd HH:mm:ss";
                break;
            }
            case DATE: {
                format = "yyyy-MM-dd";
                break;
            }
            case TIME: {
                format = "HH:mm";
                break;
            }
            default: {
                format = "";
            }
        }
        return format;
    }

    public static boolean matchType(String col, String type) {
        boolean matchFlag = true;
        if (DataType.DATE_TIME.getName().equals(type)) {
            try {
                new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(col);
            }
            catch (Exception e2) {
                matchFlag = false;
            }
        }
        if (DataType.DATE.getName().equals(type)) {
            try {
                new SimpleDateFormat("yyyy-MM-dd").parse(col);
            }
            catch (Exception e3) {
                matchFlag = false;
            }
        }
        if (DataType.TIME.getName().equals(type)) {
            try {
                new SimpleDateFormat("HH:mm").parse(col);
            }
            catch (Exception e4) {
                matchFlag = false;
            }
        }
        if (DataType.DECIMAL.getName().equals(type)) {
            try {
                Double.parseDouble(col);
            }
            catch (Exception e5) {
                matchFlag = false;
            }
        }
        if (DataType.INT.getName().equals(type)) {
            try {
                Integer.parseInt(col);
            }
            catch (Exception e6) {
                matchFlag = false;
            }
        }
        return matchFlag;
    }
}

