/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.prepare.spark.dataset;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.datastax.data.prepare.spark.dataset.p;
import com.datastax.data.prepare.spark.dataset.params.a;
import com.datastax.data.prepare.util.Consts;
import com.datastax.data.prepare.util.b;
import com.datastax.data.prepare.util.c;
import com.datastax.data.prepare.util.d;
import com.datastax.insight.annonation.InsightComponent;
import com.datastax.insight.annonation.InsightComponentArg;
import com.datastax.insight.core.driver.SparkContextBuilder;
import com.datastax.insight.spec.Operator;
import com.google.common.base.Strings;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.expressions.Window;
import org.apache.spark.sql.expressions.WindowSpec;
import org.apache.spark.sql.functions;
import org.apache.spark.sql.types.StructField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicOperator
implements Operator {
    private static final Logger logger = LoggerFactory.getLogger(BasicOperator.class);

    @InsightComponent(name="generateID", type="com.datastax.insight.dataprprocess.generateID", description="ID\u751f\u6210", order=500801)
    public static <T> Dataset<T> generateID(@InsightComponentArg(externalInput=true, name="data", description="\u6570\u636e\u96c6") Dataset<T> data, @InsightComponentArg(name="IDName", description="ID\u5c5e\u6027\u540d\u79f0", request=true) String IDName, @InsightComponentArg(name="IDType", description="ID\u7c7b\u578b", request=true, items="UUID32;Increment", defaultValue="UUID32") String IDType) {
        if (Strings.isNullOrEmpty((String)IDName) || data == null) {
            logger.info("IDName is empty");
            return data;
        }
        if ("Increment".equals(IDType)) {
            return data.withColumn(IDName, functions.lit((Object)functions.monotonically_increasing_id()));
        }
        SparkSession sparkSession = SparkContextBuilder.getSession();
        d.a(sparkSession.udf());
        return data.withColumn(IDName, functions.callUDF((String)"uuid", (Column[])new Column[]{data.col(data.columns()[0])}));
    }

    @InsightComponent(name="\u91cd\u547d\u540d", type="com.datastax.insight.dataprprocess.rename", description="\u91cd\u547d\u540d", order=500107)
    public static <T> Dataset<T> rename(@InsightComponentArg(externalInput=true, name="dataset", description="\u6570\u636e\u96c6") Dataset<T> dataset, @InsightComponentArg(name="oldName", description="\u5c5e\u6027\u539f\u6765\u7684\u540d\u5b57", request=true) String oldName, @InsightComponentArg(name="newName", description="\u5c5e\u6027\u7684\u65b0\u540d\u5b57", request=true) String newName) {
        String[] newNames;
        if (Strings.isNullOrEmpty((String)oldName) || Strings.isNullOrEmpty((String)newName) || dataset == null) {
            logger.info("oldName or newname is empty!");
            return dataset;
        }
        String[] oldNames = c.a(oldName.split(";"));
        if (oldNames.length != (newNames = c.a(newName.split(";"))).length) {
            logger.info("The number of newname is not the same as the number of oldname");
            return dataset;
        }
        for (String aNewName : newNames) {
            if (!Strings.isNullOrEmpty((String)aNewName)) continue;
            logger.info("newName is empty!");
            return dataset;
        }
        for (int i2 = 0; i2 < newNames.length; ++i2) {
            dataset = dataset.withColumnRenamed(oldNames[i2], newNames[i2]);
        }
        return dataset;
    }

    @InsightComponent(name="\u547d\u540d", description="\u547d\u540d\u7ec4\u4ef6, \u5305\u542b\u91cd\u547d\u540d\u548c\u521d\u59cb\u5316\u547d\u540d")
    public static <T> Dataset<T> name(@InsightComponentArg(externalInput=true, name="\u6570\u636e\u96c6", description="\u6570\u636e\u96c6") Dataset<T> data, @InsightComponentArg(name="\u53c2\u6570", description="\u547d\u540d\u53c2\u6570") JSONObject object) {
        if (object.isEmpty()) {
            logger.info("\u547d\u540d\u7ec4\u4ef6\u7684\u53c2\u6570\u4e3a\u7a7a,\u8fd4\u56de\u539f\u6570\u636e\u96c6");
            return data;
        }
        if (data == null) {
            logger.info("\u547d\u540d\u7ec4\u4ef6\u53c2\u6570\u4e2d\u7684\u6570\u636e\u96c6\u4e3a\u7a7a\uff0c\u8fd4\u56denull");
            return null;
        }
        String type = object.getString("selector");
        StructField[] fields = data.schema().fields();
        if ("\u521d\u59cb\u5316\u547d\u540d".equals(type)) {
            String initialType = object.getString("selectorValue");
            String value = object.getString("method").trim();
            if (value.length() == 0) {
                logger.info("\u547d\u540d\u7ec4\u4ef6\u7684\u521d\u59cb\u5316\u547d\u540d\u7684value\u4e3a\u7a7a, \u9ed8\u8ba4\u8bbe\u4e3a\u5217\u540d\u81ea\u52a8\u751f\u6210, \u524d\u7f00\u4e3a_c");
                value = "_c";
                initialType = "auto";
            }
            if ("auto".equals(initialType)) {
                String[] columns = new String[fields.length];
                for (int i2 = 0; i2 < fields.length; ++i2) {
                    columns[i2] = value + String.valueOf(i2);
                }
                return data.toDF(columns);
            }
            if ("manual".equals(initialType)) {
                String[] columns = c.a(value.split(";"));
                if (fields.length != columns.length) {
                    throw new com.datastax.data.prepare.util.a("\u521d\u59cb\u5316\u547d\u540d\u7684\u5217\u540d\u4e2a\u6570\u548c\u6570\u636e\u96c6\u7684\u5217\u540d\u4e2a\u6570\u4e0d\u76f8\u7b49");
                }
                return data.toDF(columns);
            }
        }
        if ("\u91cd\u547d\u540d".equals(type)) {
            JSONArray array = object.getJSONArray("selectorValue");
            for (int i3 = 0; i3 < array.size(); ++i3) {
                JSONObject j2 = array.getJSONObject(i3);
                String oldName = j2.getString("oldName").trim();
                String newName = j2.getString("newName").trim();
                if (oldName.length() == 0 || newName.length() == 0) {
                    logger.info("\u91cd\u547d\u540d\u7684\u67d0\u4e00\u53c2\u6570\u4e3a\u7a7a, \u8df3\u8fc7");
                }
                data = data.withColumnRenamed(oldName, newName);
            }
            return data;
        }
        return null;
    }

    @InsightComponent(name="\u805a\u5408", description="\u805a\u5408")
    public static <T> Dataset<T> aggregate(@InsightComponentArg(externalInput=true, name="\u6570\u636e\u96c6", description="\u6570\u636e\u96c6") Dataset<T> data, @InsightComponentArg(name="\u5206\u7ec4\u7c7b\u578b", description="\u5206\u7ec4\u7c7b\u578b", defaultValue="groupBy", items="groupBy;rollup;cube") String type, @InsightComponentArg(name="\u5206\u7ec4\u5217\u540d", description="\u5206\u7ec4\u7684\u5217\u540d,\u7528;\u9694\u5f00") String columns, @InsightComponentArg(name="\u805a\u5408\u51fd\u6570\u7c7b\u578b", description="\u805a\u5408\u51fd\u6570\u7c7b\u578b", defaultValue="sum", items="min;max;avg;sum;count;collect_list;collect_set;distinct_count;distinct_sum;approx_count_distinct") String funcType, @InsightComponentArg(name="\u805a\u5408\u5217\u540d", description="\u805a\u5408\u7684\u5217\u540d,\u7528;\u9694\u5f00") String funcColumns) {
        a aggregate = new a(type, columns, funcType, funcColumns);
        return BasicOperator.a(data, aggregate);
    }

    protected static <T> Dataset<T> a(Dataset<T> data, a aggregate) {
        if (aggregate.getFuncColumns() == null || aggregate.getFuncColumns().length() == 0) {
            logger.info("\u805a\u5408\u9009\u4e2d\u7684\u5217\u540d\u6570\u7ec4\u4e3a\u7a7a\uff0c\u8fd4\u56de\u539f\u6570\u636e\u96c6");
            return data;
        }
        if (aggregate.getType() == null || aggregate.getType().length() == 0) {
            aggregate.setType("groupBy");
        }
        if (aggregate.getFuncType() == null || aggregate.getFuncType().length() == 0) {
            aggregate.setFuncType("sum");
        }
        boolean groupFlag = Strings.isNullOrEmpty((String)aggregate.getColumns());
        Column[] groupColumns = BasicOperator.a(null, c.a(aggregate.getColumns().split(";")));
        Column[] aggColumns = BasicOperator.a(aggregate.getFuncType(), c.a(aggregate.getFuncColumns().split(";")));
        boolean aggFlag = aggColumns.length == 1;
        Column[] copy = null;
        if (!aggFlag) {
            copy = new Column[aggColumns.length - 1];
            if (aggColumns.length == 0) {
                throw new NullPointerException("addColumns\u4e3a\u7a7a");
            }
            System.arraycopy(aggColumns, 1, copy, 0, aggColumns.length - 1);
        }
        if ("groupBy".equals(aggregate.getType())) {
            Dataset dataset = groupFlag ? (aggFlag ? data.groupBy(new Column[0]).agg(aggColumns[0], new Column[0]) : data.groupBy(new Column[0]).agg(aggColumns[0], copy)) : (data = aggFlag ? data.groupBy(groupColumns).agg(aggColumns[0], new Column[0]) : data.groupBy(groupColumns).agg(aggColumns[0], copy));
        }
        if ("rollup".equals(aggregate.getType())) {
            Dataset dataset = groupFlag ? (aggFlag ? data.rollup(new Column[0]).agg(aggColumns[0], new Column[0]) : data.rollup(new Column[0]).agg(aggColumns[0], copy)) : (data = aggFlag ? data.rollup(groupColumns).agg(aggColumns[0], new Column[0]) : data.rollup(groupColumns).agg(aggColumns[0], copy));
        }
        if ("cube".equals(aggregate.getType())) {
            data = groupFlag ? (aggFlag ? data.cube(new Column[0]).agg(aggColumns[0], new Column[0]) : data.cube(new Column[0]).agg(aggColumns[0], copy)) : (aggFlag ? data.cube(groupColumns).agg(aggColumns[0], new Column[0]) : data.cube(groupColumns).agg(aggColumns[0], copy));
        }
        return data;
    }

    private static Column[] a(String type, String[] cols) {
        Column[] columns = new Column[cols.length];
        int j2 = 0;
        for (int i2 = 0; i2 < cols.length; ++i2) {
            if (cols[i2] == null || cols[i2].length() == 0) continue;
            if (type == null) {
                columns[j2++] = functions.col((String)cols[i2]);
                continue;
            }
            if ("min".equals(type)) {
                columns[j2++] = functions.min((Column)functions.col((String)cols[i2]));
                continue;
            }
            if ("max".equals(type)) {
                columns[j2++] = functions.max((Column)functions.col((String)cols[i2]));
                continue;
            }
            if ("avg".equals(type)) {
                columns[j2++] = functions.avg((Column)functions.col((String)cols[i2]));
                continue;
            }
            if ("sum".equals(type)) {
                columns[j2++] = functions.sum((Column)functions.col((String)cols[i2]));
                continue;
            }
            if ("count".equals(type)) {
                columns[j2++] = functions.count((Column)functions.col((String)cols[i2]));
                continue;
            }
            if ("collect_list".equals(type)) {
                columns[j2++] = functions.collect_list((Column)functions.col((String)cols[i2]));
                continue;
            }
            if ("collect_set".equals(type)) {
                columns[j2++] = functions.collect_set((Column)functions.col((String)cols[i2]));
                continue;
            }
            if ("distinct_count".equals(type)) {
                columns[j2++] = functions.countDistinct((Column)functions.col((String)cols[i2]), (Column[])new Column[0]);
                continue;
            }
            if ("distinct_sum".equals(type)) {
                columns[j2++] = functions.sumDistinct((Column)functions.col((String)cols[i2]));
                continue;
            }
            if (!"approx_count_distinct".equals(type)) continue;
            columns[j2++] = functions.approx_count_distinct((Column)functions.col((String)cols[i2]));
        }
        return columns;
    }

    @InsightComponent(name="explode", description="\u7528\u4e8e\u6570\u636e\u96c6\u7684\u67d0\u4e00\u884c\u6570\u7ec4\u62c6\u5206\u6210\u591a\u884c")
    public static <T> Dataset<T> explode(@InsightComponentArg(externalInput=true, name="\u6570\u636e\u96c6", description="\u6570\u636e\u96c6", defaultValue="${output}") Dataset<T> data, @InsightComponentArg(name="\u6269\u5c55\u884c\u6570\u636e\u683c\u5f0f", description="\u6570\u636e\u683c\u5f0f\u662f\u6570\u7ec4\u6216\u8005\u4ee5\u5206\u9694\u7b26\u9694\u5f00\u7684\u5b57\u7b26\u4e32", items="\u6570\u7ec4;\u6709\u5206\u9694\u7b26\u7684\u5b57\u7b26\u4e32") String explodeColType, @InsightComponentArg(name="\u6269\u5c55\u884c\u7684\u5217\u540d", description="\u7528\u4e8e\u6269\u5c55\u884c\u7684\u5217\u540d,\u591a\u5217\u4ee5\u5206\u9694\u7b26\u9694\u5f00") String explodeCol, @InsightComponentArg(name="\u6269\u5c55\u884c\u540e\u7684\u65b0\u5217\u540d", description="\u6269\u5c55\u884c\u540e\u7684\u65b0\u5217\u540d,\u591a\u5217\u4ee5\u5206\u9694\u7b26\u9694\u5f00") String resultCol, @InsightComponentArg(name="\u5206\u9694\u7b26", description="\u5206\u9694\u7b26") String separator) {
        if (data == null) {
            logger.info("\u6570\u636e\u96c6\u4e3a\u7a7a");
            return data;
        }
        if (explodeCol == null || explodeCol.trim().length() == 0) {
            throw new NullPointerException("\u6269\u5c55\u884c\u7684\u5217\u540d\u53c2\u6570\u4e3a\u7a7a");
        }
        if (resultCol == null || resultCol.trim().length() == 0) {
            throw new NullPointerException("\u6269\u5c55\u884c\u540e\u7684\u65b0\u5217\u540d\u4e3a\u7a7a");
        }
        if (explodeColType == null || explodeColType.trim().length() == 0) {
            throw new NullPointerException("\u6269\u5c55\u884c\u7684\u6570\u636e\u683c\u5f0f\u4e3a\u7a7a");
        }
        Dataset result = null;
        if ("\u6570\u7ec4".equals(explodeColType)) {
            StructField[] fields = data.schema().fields();
            if (!BasicOperator.a(fields, explodeCol)) {
                throw new IllegalArgumentException("\u6269\u5c55\u884c\u7684\u5217\u540d\u5728\u6570\u636e\u96c6\u4e2d\u4e0d\u5b58\u5728\u6216\u8005\u7c7b\u578b\u4e0d\u5339\u914d");
            }
            result = data.withColumn(resultCol, functions.explode((Column)functions.col((String)explodeCol)));
        } else if ("\u6709\u5206\u9694\u7b26\u7684\u5b57\u7b26\u4e32".equals(explodeColType)) {
            if (separator == null || separator.trim().length() == 0) {
                throw new NullPointerException("\u5206\u9694\u7b26\u53c2\u6570\u4e3a\u7a7a");
            }
            String separatorDeal = b.a(separator);
            result = data.withColumn(resultCol, functions.explode((Column)functions.split((Column)functions.col((String)explodeCol), (String)separatorDeal)));
        }
        if (result != null && !explodeCol.equals(resultCol)) {
            return result.drop(functions.col((String)explodeCol));
        }
        return result;
    }

    private static boolean a(StructField[] fields, String col) {
        for (StructField field : fields) {
            if (!field.name().equals(col) || !"array".equals(field.dataType().typeName())) continue;
            System.out.println("type:" + field.dataType().typeName());
            return true;
        }
        return false;
    }

    @InsightComponent(name="DatasetToRDD", description="\u6570\u636e\u96c6\u8f6c\u6362\u6210RDD")
    public static <T> RDD<T> ds2Rdd(@InsightComponentArg(externalInput=true, name="\u6570\u636e\u96c6", description="\u6570\u636e\u96c6") Dataset<T> data) {
        if (data == null) {
            throw new NullPointerException("\u6570\u636e\u96c6\u4e3a\u7a7a");
        }
        return data.rdd();
    }

    @InsightComponent(name="window", description="\u6309\u7167\u4e00\u5b9a\u53c2\u6570\u5c06\u591a\u884c\u6570\u636e\u5408\u5e76\u4e3a\u4e00\u4e2a\u7a97\u53e3\uff0c\u5e76\u8fdb\u884c\u4e00\u5b9a\u5904\u7406")
    public static <T> Dataset<T> window(@InsightComponentArg(externalInput=true, name="\u6570\u636e\u96c6", description="\u6570\u636e\u96c6") Dataset<T> data, @InsightComponentArg(name="\u5206\u7247\u7684\u5217\u540d", description="\u5206\u7247\u7684\u5217\u540d\uff0c\u4ee5\u5206\u53f7\u9694\u5f00") String partitionBys, @InsightComponentArg(name="\u6392\u5e8f\u7684\u5217\u540d", description="\u6392\u5e8f\u7684\u5217\u540d\uff0c\u4ee5\u5206\u53f7\u9694\u5f00") String orderBys, @InsightComponentArg(name="\u64cd\u4f5c\u7c7b\u578b", description="\u7528\u4e8e\u6307\u5b9a\u5bf9\u76ee\u6807\u5217\u7684\u64cd\u4f5c\u7c7b\u578b", items="collect_list") String type, @InsightComponentArg(name="\u76ee\u6807\u5217", description="\u8981\u5904\u7406\u7684\u5217\u540d") String targetCol, @InsightComponentArg(name="\u884c\u6570", description="window\u5305\u542b\u7684\u884c\u6570") int rows) {
        if (data == null) {
            throw new NullPointerException("\u6570\u636e\u96c6\u4e3a\u7a7a");
        }
        BasicOperator.a(partitionBys, "\u5206\u7247\u7684\u5217\u540d\u4e3a\u7a7a");
        BasicOperator.a(orderBys, "\u6392\u5e8f\u7684\u5217\u540d\u4e3a\u7a7a");
        BasicOperator.a(type, "\u64cd\u4f5c\u7c7b\u578b\u4e3a\u7a7a");
        BasicOperator.a(targetCol, "\u76ee\u6807\u5217\u4e3a\u7a7a");
        int num = rows <= 1 ? 1 : rows - 1;
        String[] parts = partitionBys.split(";");
        String[] orders = orderBys.split(";");
        WindowSpec window = Window.partitionBy((Column[])BasicOperator.a(data, parts)).orderBy(BasicOperator.a(data, orders)).rowsBetween(Window.currentRow(), (long)num);
        return data.withColumn(targetCol, functions.collect_list((String)targetCol).over(window));
    }

    private static void a(String s2, String errorMsg) {
        if (s2 == null || s2.trim().length() == 0) {
            throw new NullPointerException(errorMsg);
        }
    }

    private static Column[] a(Dataset dataset, String[] as) {
        Column[] cols = new Column[as.length];
        for (int i2 = 0; i2 < as.length; ++i2) {
            cols[i2] = dataset.col(as[i2]);
        }
        return cols;
    }

    @InsightComponent(name="\u591a\u7ef4\u6570\u7ec4\u5408\u5e76\u53bb\u91cd", description="\u5bf9\u4e8e\u67d0\u4e00\u5217\u8fdb\u884c\u591a\u7ef4\u6570\u7ec4\u5408\u5e76\u5e76\u53bb\u91cd\uff0c\u751f\u6210\u4e00\u7ef4\u6570\u7ec4")
    public static <T> Dataset<T> wrapArray2Array(@InsightComponentArg(externalInput=true, name="\u6570\u636e\u96c6", description="\u6570\u636e\u96c6") Dataset<T> data, @InsightComponentArg(name="\u5408\u5e76\u5217", description="\u7528\u4e8e\u5408\u5e76\u7684\u5217\uff0c\u5217\u7684\u7c7b\u578b\u5fc5\u987b\u4e3a\u591a\u7ef4\u6570\u7ec4") String wrapArrayCol) {
        if (data == null) {
            throw new NullPointerException("\u6570\u636e\u96c6\u4e3a\u7a7a");
        }
        BasicOperator.a(wrapArrayCol, "\u5408\u5e76\u5217\u53c2\u6570\u4e3a\u7a7a");
        return p.c((Dataset<Row>)data.toDF(), wrapArrayCol);
    }

    @InsightComponent(name="\u6570\u7ec4\u8f6c\u5b57\u7b26\u4e32", description="\u5c06\u6570\u7ec4\u8f6c\u6362\u6210\u5b57\u7b26\u4e32")
    public static <T> Dataset<T> array2String(@InsightComponentArg(externalInput=true, name="\u6570\u636e\u96c6", description="\u6570\u636e\u96c6") Dataset<T> data, @InsightComponentArg(name="\u5217\u540d", description="\u7528\u4e8e\u8f6c\u6362\u6210String\u7684\u5217\u540d") String arrayCol, @InsightComponentArg(name="\u8fde\u63a5\u7b26", description="\u8fde\u63a5\u7b26") String separater) {
        if (data == null) {
            throw new NullPointerException("\u6570\u636e\u96c6\u4e3a\u7a7a");
        }
        if (arrayCol == null || arrayCol.trim().length() == 0) {
            throw new NullPointerException("arrayCol\u4e3a\u7a7a");
        }
        separater = separater == null ? ";" : separater;
        StructField[] fields = data.schema().fields();
        boolean flag = false;
        for (StructField field : fields) {
            if (!field.name().equals(arrayCol) || !"array".equals(field.dataType().typeName())) continue;
            flag = true;
            break;
        }
        if (!flag) {
            throw new IllegalArgumentException(arrayCol + "\u5217\u540d\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u4e3aArray\u7c7b\u578b");
        }
        return data.withColumn(arrayCol, functions.concat_ws((String)separater, (Column[])new Column[]{functions.col((String)arrayCol)}));
    }

    @InsightComponent(name="\u6570\u5b66\u8fd0\u7b97", description="\u5bf9\u5217\u8fdb\u884c\u6570\u5b66\u8fd0\u7b97")
    public static <T> Dataset<T> mathCompute(@InsightComponentArg(externalInput=true, name="\u6570\u636e\u96c6", description="\u6570\u636e\u96c6") Dataset<T> data, @InsightComponentArg(name="\u5217\u540d", description="\u7528\u4e8e\u8ba1\u7b97\u7684\u5217\u540d") String xCol, @InsightComponentArg(name="\u8fd0\u7b97\u65b9\u6cd5", description="\u6570\u5b66\u8fd0\u7b97\u65b9\u6cd5", defaultValue="plus", items="plus;minus;multiply;divide") String method, @InsightComponentArg(name="\u7c7b\u578b", description="\u503c\u5bf9\u5e94\u7684\u7c7b\u578b\uff0c\u5217\u540d\u6216\u8005\u5e38\u91cf", defaultValue="constant", items="constant;column") String type, @InsightComponentArg(name="\u503c", description="\u8f93\u5165\u503c") String yCol) {
        if (data == null) {
            throw new IllegalArgumentException("\u6570\u636e\u96c6\u4e3a\u7a7a");
        }
        if (method == null || method.length() == 0) {
            throw new IllegalArgumentException("\u8fd0\u7b97\u65b9\u6cd5\u4e3a\u7a7a");
        }
        if (xCol == null || xCol.length() == 0) {
            throw new IllegalArgumentException("\u5217\u540d\u4e3a\u7a7a");
        }
        if (yCol == null || yCol.length() == 0) {
            throw new IllegalArgumentException("\u5217\u540d\u4e3a\u7a7a");
        }
        return com.datastax.data.prepare.spark.dataset.a.a((Dataset<Row>)data.toDF(), xCol, method, yCol, type, method + "(" + xCol + "," + yCol + ")");
    }

    @InsightComponent(name="\u5206\u7ec4\u8fc7\u6ee4", description="\u5c06\u67d0\u4e9b\u5217\u8fdb\u884c\u5206\u7ec4\u540e\u805a\u5408\uff0c\u518d\u52a0\u4e0a\u67d0\u4e9b\u6761\u4ef6\u5bf9\u805a\u5408\u540e\u7684\u7ed3\u679c\u52a0\u4ee5\u8fc7\u6ee4")
    public static <T> Dataset<T> groupFilter(@InsightComponentArg(externalInput=true, name="\u6570\u636e\u96c6", description="\u6570\u636e\u96c6") Dataset<T> data, @InsightComponentArg(name="\u5206\u7ec4\u5217", description="\u7528\u4e8e\u5206\u7ec4\u7684\u5217\uff0c\u591a\u4e2a\u5217\u7528\u5206\u53f7\u9694\u5f00") String groupColumns, @InsightComponentArg(name="\u805a\u5408\u51fd\u6570\u7c7b\u578b", description="\u805a\u5408\u51fd\u6570\u7c7b\u578b", defaultValue="count", items="min;max;avg;sum;count;distinct_count;distinct_sum;approx_count_distinct") String aggMethod, @InsightComponentArg(name="\u805a\u5408\u5217\u540d", description="\u805a\u5408\u7684\u5217\u540d") String funcColumns, @InsightComponentArg(name="\u6bd4\u8f83", description="\u6570\u5b66\u6bd4\u8f83", defaultValue="\u5927\u4e8e", items="\u5927\u4e8e;\u4e0d\u5c0f\u4e8e;\u5c0f\u4e8e;\u4e0d\u5927\u4e8e;\u7b49\u4e8e") String compare, @InsightComponentArg(name="\u9608\u503c", description="\u7528\u4e8e\u8fc7\u6ee4\u7684\u9608\u503c") double threshold) {
        int i2;
        if (aggMethod == null || aggMethod.trim().length() == 0) {
            throw new IllegalArgumentException("agg method \u4e3a\u7a7a");
        }
        if (groupColumns == null || groupColumns.trim().length() == 0) {
            throw new IllegalArgumentException("group column \u4e3a\u7a7a");
        }
        if (funcColumns == null || funcColumns.trim().length() == 0) {
            throw new IllegalArgumentException("func column \u4e3a\u7a7a");
        }
        long start2 = System.currentTimeMillis();
        System.out.println("aggregate begin");
        Dataset<T> groupDs = BasicOperator.aggregate(data, "groupBy", groupColumns, aggMethod, funcColumns);
        System.out.println("aggregate end");
        long time1 = System.currentTimeMillis();
        System.out.println("aggregate time: " + (time1 - start2));
        groupDs.persist();
        String[] colStrings = groupColumns.split(";");
        Column condition = null;
        String[] dataColumns = data.columns();
        Column[] result = new Column[dataColumns.length];
        for (i2 = 0; i2 < colStrings.length; ++i2) {
            condition = condition == null ? data.col(colStrings[i2]).equalTo((Object)groupDs.col(colStrings[i2])) : condition.and(data.col(colStrings[i2]).equalTo((Object)groupDs.col(colStrings[i2])));
        }
        for (i2 = 0; i2 < dataColumns.length; ++i2) {
            result[i2] = data.col(dataColumns[i2]);
        }
        String agg = null;
        agg = "distinct_count".equals(aggMethod) ? "count(DISTINCT " + funcColumns + ")" : ("distinct_sum".equals(aggMethod) ? "sum(DISTINCT " + funcColumns + ")" : aggMethod + "(" + funcColumns + ")");
        groupDs.unpersist();
        System.out.println("filter begin");
        Dataset<Row> filterDs = com.datastax.data.prepare.spark.dataset.a.a((Dataset<Row>)groupDs.toDF(), agg, Consts.a.b(compare), threshold);
        System.out.println("filter end ");
        long time2 = System.currentTimeMillis();
        System.out.println("filter time: " + (time2 - start2));
        filterDs.persist();
        System.out.println("join begin");
        Dataset resultDs = data.join(filterDs, condition, "right");
        System.out.println("join end");
        long time3 = System.currentTimeMillis();
        System.out.println("filter time: " + (time3 - start2));
        filterDs.unpersist();
        return resultDs.select(result);
    }

    @InsightComponent(name="count", description="count")
    public static <T> Dataset<T> countRow(@InsightComponentArg(externalInput=true, name="\u6570\u636e\u96c6", description="\u6570\u636e\u96c6") Dataset<T> data) {
        SparkSession spark = SparkContextBuilder.getSession();
        spark.log().info("\u6570\u636e\u96c6\u884c\u6570\u4e3a\uff1a " + data.count());
        return data;
    }

    @InsightComponent(name="\u65f6\u95f4\u8fc7\u6ee4", description="\u65f6\u95f4\u8fc7\u6ee4")
    public static <T> Dataset<T> filterDate(@InsightComponentArg(externalInput=true, name="\u6570\u636e\u96c6", description="\u6570\u636e\u96c6") Dataset<T> data, @InsightComponentArg(name="\u65f6\u95f4\u5217", description="\u7528\u4e8e\u6bd4\u8f83\u7684\u65f6\u95f4\u5217") String dateColumn, @InsightComponentArg(name="\u8d77\u59cb\u65f6\u95f4", description="\u8d77\u59cb\u65f6\u95f4") String startDate, @InsightComponentArg(name="\u7ec8\u6b62\u65f6\u95f4", description="\u7ec8\u6b62\u65f6\u95f4") String endDate, @InsightComponentArg(name="\u65f6\u95f4\u683c\u5f0f", description="\u65f6\u95f4\u683c\u5f0f\uff0c\u4f8b\u5982yyyy-MM-dd") String dateFormat) {
        if (data == null) {
            throw new NullPointerException("\u6570\u636e\u96c6\u4e3a\u7a7a");
        }
        if (BasicOperator.a(dateColumn)) {
            throw new NullPointerException("\u65f6\u95f4\u5217\u4e3a\u7a7a");
        }
        if (BasicOperator.a(dateFormat)) {
            throw new NullPointerException("\u65f6\u95f4\u683c\u5f0f\u4e3a\u7a7a");
        }
        Column condition = null;
        boolean f1 = BasicOperator.a(startDate);
        boolean f2 = BasicOperator.a(endDate);
        if (f1 && f2) {
            return data;
        }
        condition = !f1 && !f2 ? functions.date_format((Column)data.col(dateColumn), (String)dateFormat).geq((Object)functions.date_format((Column)functions.lit((Object)startDate), (String)dateFormat)).and(functions.date_format((Column)data.col(dateColumn), (String)dateFormat).leq((Object)functions.date_format((Column)functions.lit((Object)endDate), (String)dateFormat))) : (f1 ? functions.date_format((Column)data.col(dateColumn), (String)dateFormat).leq((Object)functions.date_format((Column)functions.lit((Object)endDate), (String)dateFormat)) : functions.date_format((Column)data.col(dateColumn), (String)dateFormat).geq((Object)functions.date_format((Column)functions.lit((Object)startDate), (String)dateFormat)));
        return data.filter(condition);
    }

    @InsightComponent(name="\u53bb\u91cd", description="\u53bb\u91cd")
    public static <T> Dataset<T> distinct(@InsightComponentArg(externalInput=true, name="\u6570\u636e\u96c6", description="\u6570\u636e\u96c6") Dataset<T> data) {
        return data.distinct();
    }

    private static boolean a(String s2) {
        return s2 == null || s2.trim().length() == 0;
    }

    @InsightComponent(name="checkpoint", description="checkpoint")
    public static <T> Dataset<T> checkpoint(@InsightComponentArg(externalInput=true, name="\u6570\u636e\u96c6", description="\u6570\u636e\u96c6") Dataset<T> data, @InsightComponentArg(name="\u8def\u5f84", description="\u8def\u5f84", defaultValue="${MISC_FOLDER}") String path) {
        SparkSession spark = SparkContextBuilder.getSession();
        spark.sparkContext().setCheckpointDir(path + "/checkpoint");
        return data.checkpoint();
    }
}

