/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.prepare.spark.dataset;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.datastax.data.prepare.spark.dataset.params.c;
import com.datastax.data.prepare.util.a;
import com.datastax.insight.annonation.InsightComponent;
import com.datastax.insight.annonation.InsightComponentArg;
import com.datastax.insight.spec.Operator;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnReduceOperater
implements Operator {
    private static final Logger logger = LoggerFactory.getLogger(ColumnReduceOperater.class);

    @InsightComponent(name="\u5217\u5408\u5e76", description="\u5c06\u591a\u4e2a\u5217\u5408\u5e76")
    public static <T> Dataset<T> columnReduce(@InsightComponentArg(externalInput=true, name="\u6570\u636e\u96c6", description="\u6570\u636e\u96c6") Dataset<T> data, @InsightComponentArg(name="\u53c2\u6570", description="\u53c2\u6570") JSONArray jsonArray) {
        if (jsonArray.isEmpty()) {
            logger.info("\u5217\u5408\u5e76\u7ec4\u4ef6\u53c2\u6570\u4e3a\u7a7a, \u8fd4\u56de\u539f\u6570\u636e\u96c6");
            return data;
        }
        if (data == null) {
            logger.info("\u5217\u5408\u5e76\u7ec4\u4ef6\u4e2d\u7684\u6570\u636e\u96c6\u4e3a\u7a7a, \u8fd4\u56de\u7a7a");
            return null;
        }
        c[] columnReduceParams = new c[jsonArray.size()];
        for (int i2 = 0; i2 < jsonArray.size(); ++i2) {
            JSONObject jsonObject = jsonArray.getJSONObject(i2);
            String mergeColumns = jsonObject.getString("selector");
            String connectSymbol = jsonObject.getString("selectorValue");
            String newColumnName = jsonObject.getString("method");
            String dataType = jsonObject.getString("methodValue");
            if (mergeColumns == null || mergeColumns.length() == 0) {
                throw new a("\u5408\u5e76\u5217\u7684\u53c2\u6570\u4e3a\u7a7a");
            }
            if (newColumnName == null || newColumnName.length() == 0) {
                throw new a("\u5408\u5e76\u5217\u540e\u751f\u6210\u7684\u65b0\u5217\u540d\u53c2\u6570\u4e3a\u7a7a");
            }
            c columnReduceParam = new c();
            columnReduceParam.setMergeColumns(mergeColumns);
            columnReduceParam.setConnectSymbol(connectSymbol);
            columnReduceParam.setNewColumnName(newColumnName);
            columnReduceParam.setDataType(dataType);
            columnReduceParams[i2] = columnReduceParam;
        }
        return com.datastax.data.prepare.spark.dataset.c.a((Dataset<Row>)data.toDF(), columnReduceParams);
    }
}

