/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.prepare.spark.dataset;

import com.alibaba.fastjson.JSONArray;
import com.datastax.insight.annonation.InsightComponent;
import com.datastax.insight.annonation.InsightComponentArg;
import com.datastax.insight.core.driver.SparkContextBuilder;
import com.datastax.insight.spec.Operator;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSampleOperator
implements Operator {
    private static final Logger logger = LoggerFactory.getLogger(DataSampleOperator.class);

    @InsightComponent(name="\u6570\u636e\u91c7\u6837", description="\u6570\u636e\u91c7\u6837", order=500304)
    public static <T> Dataset<T> dataSample(@InsightComponentArg(externalInput=true, name="data", description="\u6570\u636e\u96c6") Dataset<T> dataset, @InsightComponentArg(name="withReplacement", description="\u662f\u5426\u653e\u56de\u62bd\u6837") boolean withReplacement, @InsightComponentArg(name="sampleType", description="Sample\u7c7b\u578b", items="absolute,relative,probability", defaultValue="absolute") String sampleType, @InsightComponentArg(name="editList", description="\u914d\u7f6e\u5217\u8868") String json) throws IOException {
        if (dataset == null) {
            logger.info("dataset is empty!");
            return null;
        }
        StructType schema = dataset.schema();
        List<List> propertyList = DataSampleOperator.a(json);
        switch (sampleType) {
            case "absolute": {
                dataset = DataSampleOperator.a(dataset, withReplacement, schema, propertyList);
                break;
            }
            case "relative": {
                dataset = DataSampleOperator.b(dataset, withReplacement, schema, propertyList);
                break;
            }
            case "probability": {
                dataset = DataSampleOperator.a(dataset, withReplacement, propertyList);
                break;
            }
            default: {
                return dataset;
            }
        }
        return dataset;
    }

    private static List<List> a(String json) throws IOException {
        ArrayList<List> propertyList = new ArrayList<List>();
        ObjectMapper objectMapper = new ObjectMapper();
        List list = (List)objectMapper.readValue(json, List.class);
        for (Map map : list) {
            ArrayList property = new ArrayList();
            property.add(map.get("selector"));
            property.add(map.get("selectorValue"));
            propertyList.add(property);
        }
        return propertyList;
    }

    private static <T> Dataset<T> a(Dataset<T> dataset, boolean withReplacement, StructType schema, List<List> propertylist) {
        ArrayList sampleList = new ArrayList();
        if (!propertylist.get(0).get(0).equals("balance")) {
            if (Double.parseDouble(propertylist.get(0).get(1).toString()) % 1.0 != 0.0) {
                logger.info("absoluteSample num must be int type!");
                return dataset;
            }
            int num = Integer.parseInt(propertylist.get(0).get(1).toString());
            if (num > 0) {
                sampleList.addAll(dataset.javaRDD().takeSample(withReplacement, num));
                return SparkContextBuilder.getSession().createDataFrame(sampleList, schema);
            }
            logger.info("absoluteSample num is less than 0!");
            return dataset;
        }
        List<List> balancePropertyList = propertylist.subList(1, propertylist.size());
        for (int i2 = 0; i2 < balancePropertyList.size(); ++i2) {
            if (Double.parseDouble(balancePropertyList.get(i2).get(1).toString()) % 1.0 != 0.0) {
                logger.info("absoluteSample num must be int type!");
                return dataset;
            }
            int num = Integer.parseInt(balancePropertyList.get(i2).get(1).toString());
            Dataset ds = dataset.filter(balancePropertyList.get(i2).get(0).toString());
            if (num <= 0) {
                logger.info("absoluteSample num is less than 0!");
                return dataset;
            }
            sampleList.addAll(ds.javaRDD().takeSample(withReplacement, num));
        }
        return SparkContextBuilder.getSession().createDataFrame(sampleList, schema);
    }

    private static <T> Dataset<T> b(Dataset<T> dataset, boolean withReplacement, StructType schema, List<List> propertylist) {
        ArrayList sampleList = new ArrayList();
        if (!propertylist.get(0).get(0).equals("balance")) {
            int num = (int)(Double.parseDouble(propertylist.get(0).get(1).toString()) * (double)dataset.collectAsList().size());
            if (num > 0) {
                sampleList.addAll(dataset.javaRDD().takeSample(withReplacement, num));
                return SparkContextBuilder.getSession().createDataFrame(sampleList, schema);
            }
            logger.info("relativeSample ratio is less than 0!");
            return dataset;
        }
        List<List> balancePropertyList = propertylist.subList(1, propertylist.size());
        for (List aBalancePropertyList : balancePropertyList) {
            Dataset ds = dataset.filter(aBalancePropertyList.get(0).toString());
            int num = (int)(Double.parseDouble(aBalancePropertyList.get(1).toString()) * (double)ds.collectAsList().size());
            if (num > 0) {
                sampleList.addAll(ds.javaRDD().takeSample(withReplacement, num));
                continue;
            }
            logger.info("relativeSample ratio is less than 0!");
            return dataset;
        }
        return SparkContextBuilder.getSession().createDataFrame(sampleList, schema);
    }

    private static <T> Dataset<T> a(Dataset<T> dataset, boolean withReplacement, List<List> propertylist) {
        Dataset ds = null;
        if (!propertylist.get(0).get(0).equals("balance")) {
            double probability = Double.parseDouble(propertylist.get(0).get(1).toString());
            if (probability > 0.0 && probability < 1.0) {
                return dataset.sample(withReplacement, probability);
            }
            logger.info("probabilitySample probability is out of range!");
            return dataset;
        }
        List<List> balancePropertyList = propertylist.subList(1, propertylist.size());
        for (int i2 = 0; i2 < balancePropertyList.size(); ++i2) {
            double probability = Double.parseDouble(balancePropertyList.get(i2).get(1).toString());
            if (probability > 0.0 && probability < 1.0) {
                if (i2 == 0) {
                    ds = dataset.filter(balancePropertyList.get(i2).get(0).toString()).sample(withReplacement, probability);
                    continue;
                }
                ds = ds.union(dataset.filter(balancePropertyList.get(i2).get(0).toString()).sample(withReplacement, probability));
                continue;
            }
            logger.info("probabilitySample probability is out of range!");
            return dataset;
        }
        return ds;
    }

    @InsightComponent(name="\u6570\u636e\u91c7\u6837", description="\u6570\u636e\u91c7\u6837", order=500304)
    public static <T> Dataset<T> dataSample(@InsightComponentArg(externalInput=true, name="data", description="\u6570\u636e\u96c6") Dataset<T> dataset, @InsightComponentArg(name="withReplacement", description="\u662f\u5426\u653e\u56de\u62bd\u6837") boolean withReplacement, @InsightComponentArg(name="sampleType", description="Sample\u7c7b\u578b", items="absolute,relative,probability", defaultValue="absolute") String sampleType, @InsightComponentArg(name="propertylist", description="\u53c2\u6570\u5217\u8868") JSONArray jsonArray) throws IOException {
        return DataSampleOperator.dataSample(dataset, withReplacement, sampleType, jsonArray.toString());
    }
}

