/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.prepare.spark.dataset;

import com.datastax.data.prepare.util.c;
import com.datastax.insight.annonation.InsightComponent;
import com.datastax.insight.annonation.InsightComponentArg;
import com.datastax.insight.spec.Operator;
import java.util.Map;
import org.apache.parquet.Strings;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.api.java.function.MapPartitionsFunction;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Row;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class DataSetTransformation
implements Operator {
    private static final Logger logger = LoggerFactory.getLogger(DataSetTransformation.class);

    protected static <T> Dataset<Row> join(Dataset<T> left, Dataset<T> right, Column joinExprs, String joinType) {
        return left.join(right, joinExprs, joinType);
    }

    protected static <T, U> Dataset<Tuple2<T, U>> joinWith(Dataset<T> left, Dataset<U> right, Column joinExprs, String joinType) {
        return left.joinWith(right, joinExprs, joinType);
    }

    @InsightComponent(name="Join", description="Join", type="com.datastax.insight.dataprprocess.join", icon="arrows", order=50010501)
    public static <T> Dataset<Row> join(@InsightComponentArg(externalInput=true, name="\u5de6\u6570\u636e\u96c6", description="left dataset") Dataset<T> left, @InsightComponentArg(externalInput=true, name="\u53f3\u6570\u636e\u96c6", description="right dataset") Dataset<T> right, @InsightComponentArg(name="\u5de6\u5217\u540d", description="keyLeft") String keyLeft, @InsightComponentArg(name="\u53f3\u5217\u540d", description="keyRight") String keyRight, @InsightComponentArg(name="\u8fde\u63a5\u65b9\u6cd5", description="join\u65b9\u6cd5", defaultValue="innner", items="inner;outer;left_outer;right_outer;left_semi") String joinType) {
        if (left == null || right == null) {
            logger.info("left\u6216\u8005right\u6570\u636e\u96c6\u4e3a\u7a7a\uff0c\u8fd4\u56deleft\u6570\u636e\u96c6");
            return left.toDF();
        }
        if (joinType == null || joinType.length() == 0) {
            joinType = "inner";
        }
        return left.join(right, left.col(keyLeft).equalTo((Object)right.col(keyRight)), joinType);
    }

    @InsightComponent(name="JoinMutil", description="JoinMutil", type="com.datastax.insight.dataprprocess.join", icon="arrows")
    public static <T> Dataset<Row> joinMutil(@InsightComponentArg(externalInput=true, name="\u5de6\u6570\u636e\u96c6", description="left dataset") Dataset<T> left, @InsightComponentArg(externalInput=true, name="\u53f3\u6570\u636e\u96c6", description="right dataset") Dataset<T> right, @InsightComponentArg(name="\u5de6\u5404\u5217\u540d", description="\u5de6\u5404\u5217\u540d\uff0c\u4ee5\u5206\u53f7\u9694\u5f00") String keyLefts, @InsightComponentArg(name="\u53f3\u5404\u5217\u540d", description="\u5de6\u5404\u5217\u540d\uff0c\u4ee5\u5206\u53f7\u9694\u5f00") String keyRights, @InsightComponentArg(name="\u8fde\u63a5\u65b9\u6cd5", description="join\u65b9\u6cd5", defaultValue="innner", items="inner;outer;left_outer;right_outer;left_semi") String joinType) {
        if (left == null || right == null) {
            logger.info("left\u6216\u8005right\u6570\u636e\u96c6\u4e3a\u7a7a\uff0c\u8fd4\u56deleft\u6570\u636e\u96c6");
            return left.toDF();
        }
        if (joinType == null || joinType.length() == 0) {
            joinType = "inner";
        }
        Column conditionColumn = null;
        String[] keyLeftArray = keyLefts.split(";");
        String[] keyRightArray = keyRights.split(";");
        for (int i2 = 0; i2 < keyLeftArray.length; ++i2) {
            conditionColumn = i2 == 0 ? left.col(keyLeftArray[i2]).equalTo((Object)right.col(keyRightArray[i2])) : conditionColumn.and(left.col(keyLeftArray[i2]).equalTo((Object)right.col(keyRightArray[i2])));
        }
        return left.join(right, conditionColumn, joinType);
    }

    @InsightComponent(name="Split", description="Split", type="com.datastax.insight.dataprprocess.split1", icon="arrows", order=500501)
    public static <T> Dataset<T>[] split(@InsightComponentArg(externalInput=true, name="\u6570\u636e\u96c6", description="\u8f93\u5165\u7684DataSet") Dataset<T> dataSet, @InsightComponentArg(name="\u6570\u636e\u5207\u5206\u6743\u91cd", description="\u5206\u5272\u6bd4\u4f8b") String weights) {
        if (dataSet == null || Strings.isNullOrEmpty((String)weights)) {
            logger.info("\u6570\u636e\u96c6\u4e3a\u7a7a\u6216\u8005weights\u4e3a\u7a7a");
            return new Dataset[]{dataSet};
        }
        String[] strs = weights.split(";");
        double[] doubles = new double[strs.length];
        for (int i2 = 0; i2 < strs.length; ++i2) {
            if (!strs[i2].matches("\\d+\\.?\\d*")) continue;
            doubles[i2] = Double.parseDouble(strs[i2]);
        }
        return dataSet.randomSplit(doubles);
    }

    @InsightComponent(name="Split", description="Split", type="com.datastax.insight.dataprprocess.split", icon="arrows", order=500501)
    public static <T> Dataset<T>[] split(@InsightComponentArg(externalInput=true, name="\u6570\u636e\u96c6", description="\u8f93\u5165\u7684DataSet") Dataset<T> dataSet, @InsightComponentArg(name="\u6570\u636e\u5207\u5206\u6743\u91cd", description="\u5206\u5272\u6bd4\u4f8b") double[] weights) {
        if (dataSet == null || weights.length == 0) {
            logger.info("\u6570\u636e\u96c6\u4e3a\u7a7a\u6216\u8005weights\u4e3a\u7a7a");
            return new Dataset[]{dataSet};
        }
        return dataSet.randomSplit(weights);
    }

    @InsightComponent(name="Union", description="Union", type="com.datastax.insight.dataprprocess.union", icon="arrows", order=50010502)
    public static <T> Dataset<T> union(@InsightComponentArg(externalInput=true, name="\u5de6\u6570\u636e\u96c6", description="left dataset") Dataset<T> left, @InsightComponentArg(externalInput=true, name="\u53f3\u6570\u636e\u96c6", description="right dataset") Dataset<T> right) {
        if (left == null || right == null) {
            logger.info("\u6570\u636e\u96c6\u4e3a\u7a7a,\u8fd4\u56deleft\u6570\u636e\u96c6");
            return left;
        }
        if (left.schema().fieldNames().length != right.schema().fieldNames().length) {
            logger.info("left\u548cright\u6570\u636e\u96c6\u7684\u5217\u6570\u4e0d\u7b49\uff0c\u4e0d\u80fd\u8fdb\u884cunion\u64cd\u4f5c\uff0c\u8fd4\u56deleft\u6570\u636e\u96c6");
            return left;
        }
        return left.union(right);
    }

    protected static <T, U> Dataset<U> as(Dataset<T> dataset, Encoder<U> u2) {
        return dataset.as(u2);
    }

    @InsightComponent(name="Alias", description="Alias", type="com.datastax.insight.dataprprocess.alias", icon="arrows", order=50010802)
    public static <T> Dataset<T> alias(@InsightComponentArg(externalInput=true, name="\u6570\u636e\u96c6", description="\u64cd\u4f5c\u6570\u636e") Dataset<T> dataset, @InsightComponentArg(name="\u522b\u540d", description="alias") String alias) {
        return dataset.as(alias);
    }

    @InsightComponent(name="\u6392\u5e8f", description="Sort", type="com.datastax.insight.dataprprocess.sort", icon="arrows", order=50010601)
    public static <T> Dataset<T> sort(@InsightComponentArg(externalInput=true, name="\u6570\u636e\u96c6", description="\u64cd\u4f5c\u6570\u636e") Dataset<T> dataset, @InsightComponentArg(name="\u7c7b\u578b", description="\u6392\u5e8f\u7c7b\u578b", defaultValue="sort", items="sort;sortWithinPartitions;orderBy") String type, @InsightComponentArg(name="\u5217\u540d", description="\u6392\u5e8f\u5217\uff0c\u7528\u5206\u53f7\u9694\u5f00") String cols, @InsightComponentArg(name="\u6392\u5217\u7c7b\u578b", description="\u8bbe\u7f6e\u5217\u4ece\u5927\u5230\u5c0f\u6216\u8005\u4ece\u5c0f\u5230\u5927\u6392\u5217", defaultValue="ASC", items="DESC;ASC") String orderType) {
        String[] columns = cols.split(";");
        if (columns.length == 0) {
            logger.info("\u9009\u62e9\u7684\u5217\u540d\u4e3a\u7a7a\uff0c\u8fd4\u56de\u539f\u6570\u636e\u96c6");
            return dataset;
        }
        if (type == null || type.length() == 0) {
            type = "sort";
        }
        boolean flag = false;
        if ("DESC".equals(orderType)) {
            flag = true;
        }
        Column[] temp = new Column[columns.length];
        for (int i2 = 0; i2 < columns.length; ++i2) {
            temp[i2] = flag ? dataset.col(columns[i2]).desc_nulls_last() : dataset.col(columns[i2]).asc_nulls_last();
        }
        if ("sort".equals(type)) {
            return dataset.sort(temp);
        }
        if ("sortWithinPartitions".equals(type)) {
            return dataset.sortWithinPartitions(temp);
        }
        if ("orderBy".equals(type)) {
            return dataset.orderBy(temp);
        }
        logger.info("type\u4e0d\u5728\u53ef\u9009\u503c\u5185\uff0c\u8fd4\u56de\u539f\u6570\u636e\u96c6");
        return dataset;
    }

    @InsightComponent(name="Select", description="Select", type="com.datastax.insight.dataprprocess.select", icon="arrows", order=50010102)
    public static <T> Dataset<Row> select(@InsightComponentArg(externalInput=true, name="\u6570\u636e\u96c6", description="\u64cd\u4f5c\u6570\u636e") Dataset<T> dataset, @InsightComponentArg(name="\u7c7b\u578b", description="\u9009\u62e9\u7684\u7c7b\u578b", defaultValue="column", items="column;expression") String type, @InsightComponentArg(name="\u5217\u540d", description="\u9009\u62e9\u5217\uff0c\u4ee5\u5206\u53f7\u9694\u5f00") String cols) {
        String[] columns = c.a(cols.split(";"));
        if (columns.length == 0 || dataset == null) {
            logger.info("\u9009\u62e9\u7684\u5217\u540d\u4e3a\u7a7a\u6216\u8005\u6570\u636e\u96c6\u4e3a\u7a7a\uff0c\u8fd4\u56de\u539f\u6570\u636e\u96c6");
            return dataset.toDF();
        }
        if (type == null || type.length() == 0) {
            type = "column";
        }
        if ("column".equals(type)) {
            if (columns.length == 1) {
                return dataset.select(columns[0], new String[0]);
            }
            String[] copy = new String[columns.length - 1];
            System.arraycopy(columns, 1, copy, 0, columns.length - 1);
            return dataset.select(columns[0], copy);
        }
        if ("expression".equals(type)) {
            return dataset.selectExpr(columns);
        }
        logger.info("type\u4e0d\u5728\u53ef\u9009\u503c\u5185\uff0c\u8fd4\u56de\u539f\u6570\u636e\u96c6");
        return dataset.toDF();
    }

    @InsightComponent(name="Filter", description="Filter", type="com.datastax.insight.dataprprocess.filter", icon="arrows", order=50010201)
    public static <T> Dataset<T> filter(@InsightComponentArg(externalInput=true, name="\u6570\u636e\u96c6", description="\u64cd\u4f5c\u6570\u636e") Dataset<T> dataset, @InsightComponentArg(name="\u8868\u8fbe\u5f0f", description="\u8868\u8fbe\u5f0f") String expr) {
        if (dataset == null || expr == null || expr.length() == 0) {
            logger.info("\u6570\u636e\u96c6\u4e3a\u7a7a\u6216\u8005\u8868\u8fbe\u5f0f\u4e3a\u7a7a\uff0c\u8fd4\u56de\u539f\u6570\u636e\u96c6");
            return dataset;
        }
        return dataset.filter(expr);
    }

    protected static <T> Dataset<T> where(Dataset<T> dataset, String expr) {
        return dataset.where(expr);
    }

    protected static <T> Dataset<Row> agg(Dataset<T> dataset, Map<String, String> map) {
        return dataset.agg(map);
    }

    @InsightComponent(name="Limit", description="Limit", type="com.datastax.insight.dataprprocess.limit", icon="arrows", order=50010101)
    public static <T> Dataset<T> limit(@InsightComponentArg(externalInput=true, name="\u6570\u636e\u96c6", description="\u64cd\u4f5c\u6570\u636e") Dataset<T> dataset, @InsightComponentArg(name="\u884c\u6570", description="limit n") int n2) {
        if (dataset == null) {
            logger.info("\u6570\u636e\u96c6\u4e3a\u7a7a");
            return dataset;
        }
        if (n2 < 0) {
            logger.info("n\u5c0f\u4e8e0, \u9ed8\u8ba4\u4e3a20");
            n2 = 20;
        }
        return dataset.limit(n2);
    }

    @InsightComponent(name="\u4ea4\u96c6", description="Intersect", type="com.datastax.insight.dataprprocess.intersect", icon="arrows", order=50010505)
    public static <T> Dataset<T> intersect(@InsightComponentArg(externalInput=true, name="\u6570\u636e\u96c61", description="\u64cd\u4f5c\u6570\u636e1") Dataset<T> dataset1, @InsightComponentArg(externalInput=true, name="\u6570\u636e\u96c62", description="\u64cd\u4f5c\u6570\u636e2") Dataset<T> dataset2) {
        if (dataset1 == null || dataset2 == null) {
            logger.info("\u6570\u636e\u96c6\u4e3a\u7a7a,\u8fd4\u56denull");
            return dataset1;
        }
        return dataset1.intersect(dataset2);
    }

    @InsightComponent(name="\u5dee\u96c6", description="Except", type="com.datastax.insight.dataprprocess.expect", icon="arrows", order=50010202)
    public static <T> Dataset<T> except(@InsightComponentArg(externalInput=true, name="\u6570\u636e\u96c61", description="\u64cd\u4f5c\u6570\u636e1") Dataset<T> dataset1, @InsightComponentArg(externalInput=true, name="\u6570\u636e\u96c62", description="\u64cd\u4f5c\u6570\u636e2") Dataset<T> dataset2) {
        if (dataset1 == null || dataset2 == null) {
            logger.info("\u6570\u636e\u96c6\u4e3a\u7a7a,\u8fd4\u56denull");
            return dataset1;
        }
        return dataset1.except(dataset2);
    }

    protected static <T> Dataset<Row> withColumnRenamed(Dataset<T> dataset, String existingName, String newName) {
        return dataset.withColumnRenamed(existingName, newName);
    }

    @InsightComponent(name="Drop", description="Drop", type="com.datastax.insight.dataprprocess.drop", icon="arrows", order=50010104)
    public static <T> Dataset<Row> drop(@InsightComponentArg(externalInput=true, name="\u6570\u636e\u96c6", description="dataset") Dataset<T> dataset, @InsightComponentArg(name="\u7c7b\u578b", description="drop \u7684\u7c7b\u578b", defaultValue="drop", items="drop;drop duplicates") String type, @InsightComponentArg(name="\u5217\u540d", description="\u4e22\u5f03\u7684\u5217\u540d\uff0c\u7528\u5206\u53f7\u9694\u5f00") String cols) {
        String[] columns = c.a(cols.split(";"));
        if (type == null || type.length() == 0) {
            type = "drop";
        }
        if ("drop".equals(type)) {
            if (columns.length == 0) {
                logger.info("\u5217\u540d\u4e3a\u7a7a, \u8fd4\u56de\u539f\u6570\u636e\u96c6");
                return dataset.toDF();
            }
            return dataset.drop(columns);
        }
        if ("drop duplicates".equals(type)) {
            if (columns.length == 0) {
                return dataset.dropDuplicates().toDF();
            }
            return dataset.dropDuplicates(columns).toDF();
        }
        logger.info("type\u4e0d\u518d\u53ef\u9009\u9879\u5185, \u8fd4\u56de\u539f\u6570\u636e\u96c6");
        return dataset.toDF();
    }

    @InsightComponent(name="Map", description="Map", type="com.datastax.insight.dataprprocess.map", icon="arrows", order=50010803)
    public static <T, U> Dataset<U> map(@InsightComponentArg(name="\u6570\u636e\u96c6", description="\u64cd\u4f5c\u6570\u636e") Dataset<T> dataset, @InsightComponentArg(name="\u51fd\u6570") MapFunction<T, U> func, @InsightComponentArg(name="\u7f16\u7801\u5668") Encoder<U> u2) {
        return dataset.map(func, u2);
    }

    protected static <T, U> Dataset<U> mapPartitions(Dataset<T> dataset, MapPartitionsFunction<T, U> func, Encoder<U> u2) {
        return dataset.mapPartitions(func, u2);
    }

    protected static <T, U> Dataset<U> flatMap(Dataset<T> dataset, FlatMapFunction<T, U> func, Encoder<U> u2) {
        return dataset.flatMap(func, u2);
    }

    @InsightComponent(name="Repartition", description="Repartition", type="com.datastax.insight.dataprprocess.repartition", icon="arrows", order=50010504)
    public static <T> Dataset<T> repartition(@InsightComponentArg(externalInput=true, name="data", description="\u64cd\u4f5c\u6570\u636e") Dataset<T> dataset, @InsightComponentArg(name="n", description="n") int n2) {
        return dataset.repartition(n2);
    }

    @InsightComponent(name="Coalesce", description="Coalesce", type="com.datastax.insight.dataprprocess.coalesce", icon="arrows", order=50010503)
    public static <T> Dataset<T> coalesce(@InsightComponentArg(externalInput=true, name="data", description="\u64cd\u4f5c\u6570\u636e") Dataset<T> dataset, @InsightComponentArg(name="n", description="n") int n2) {
        return dataset.coalesce(n2);
    }

    @InsightComponent(name="toJavaRDD", description="toJavaRDD", type="com.datastax.insight.dataprprocess.toJavaRDD", icon="arrows", order=500204)
    public static <T> JavaRDD<T> toJavaRDD(@InsightComponentArg(externalInput=true, name="data", description="\u64cd\u4f5c\u6570\u636e") Dataset<T> dataset) {
        return dataset.toJavaRDD();
    }

    @InsightComponent(name="toJson", description="toJson", type="com.datastax.insight.dataprprocess.toJson", icon="arrows", order=500203)
    public static <T> Dataset<String> toJSON(@InsightComponentArg(externalInput=true, name="data", description="\u64cd\u4f5c\u6570\u636e") Dataset<T> dataset) {
        return dataset.toJSON();
    }

    protected static <T> Dataset<Row> toDF(Dataset<T> dataset) {
        return dataset.toDF();
    }

    protected static <T> Dataset<Row> toDF(Dataset<T> dataset, String[] cols) {
        return dataset.toDF(cols);
    }

    @InsightComponent(name="toDF", description="toDF", type="com.datastax.insight.dataprprocess.toDF", icon="arrows", order=500201)
    public static <T> Dataset<Row> toDF(@InsightComponentArg(externalInput=true, name="\u6570\u636e\u96c6") Dataset<T> dataset, @InsightComponentArg(name="\u5217\u540d") String cols) {
        if (dataset == null) {
            return dataset.toDF();
        }
        String[] columns = new String[dataset.columns().length];
        if (cols == null || cols.length() == 0) {
            String preffix = "_c";
            for (int i2 = 0; i2 < columns.length; ++i2) {
                columns[i2] = preffix + String.valueOf(i2);
            }
        } else {
            columns = c.a(cols.split(";"));
        }
        return dataset.toDF(columns);
    }

    protected static <T> Dataset<Row> cast(Dataset<T> dataset, String column, String type) {
        String[] columns = column.split(";");
        Dataset result = null;
        for (String c2 : columns) {
            result = result == null ? dataset.withColumn(c2, dataset.col(c2).cast(type)) : result.withColumn(c2, dataset.col(c2).cast(type));
        }
        return result == null ? dataset.toDF() : result;
    }

    @InsightComponent(name="Show", description="Show", type="com.datastax.insight.dataprprocess.show")
    public static <T> void show(@InsightComponentArg(name="\u6570\u636e\u96c6", description="\u6570\u636e\u96c6") Dataset<T> data, @InsightComponentArg(name="\u884c\u6570", description="\u663e\u793a\u7684\u884c\u6570", defaultValue="10") int numRows, @InsightComponentArg(name="\u5b57\u7b26\u6570", description="\u663e\u793a\u7684\u5b57\u7b26\u6570", defaultValue="20") int truncate) {
        if (data == null) {
            logger.info("\u6570\u636e\u96c6\u4e3a\u7a7a");
            return;
        }
        numRows = numRows < 0 ? 10 : numRows;
        truncate = truncate < 0 ? 20 : truncate;
        System.out.println("===DataExa-Insight User Output Started===");
        data.show(numRows, truncate);
        System.out.println("===DataExa-Insight User Output Ended===");
    }
}

