/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.data.prepare.spark.dataset;

import com.datastax.insight.annonation.InsightComponent;
import com.datastax.insight.annonation.InsightComponentArg;
import com.datastax.insight.core.driver.SparkContextBuilder;
import com.datastax.insight.core.entity.Cache;
import com.datastax.insight.core.entity.DBSource;
import com.datastax.insight.core.service.PersistService;
import com.datastax.insight.spec.Operator;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.DataFrameWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.storage.StorageLevel;

public class DataSetWriter
implements Operator {
    public static <T> void save(Dataset<T> dataset, String format, String mode, String path) throws Exception {
        DataSetWriter.save(dataset, format, mode, path, true);
    }

    public static <T> void save(Dataset<T> dataset, String format, String mode, String path, boolean withHeader) throws Exception {
        Configuration conf = new Configuration();
        FileSystem hdfs = FileSystem.get((URI)new URI(path), (Configuration)conf);
        String temp = new Path(hdfs.getWorkingDirectory(), "temp_" + String.valueOf(System.currentTimeMillis())).toString();
        DataFrameWriter writer = dataset.write();
        if (withHeader) {
            writer.option("header", true);
        }
        writer.format(format).mode(mode).save(temp);
        if (hdfs.exists(new Path(path))) {
            hdfs.delete(new Path(path), true);
        }
        FileUtil.copyMerge((FileSystem)hdfs, (Path)new Path(temp), (FileSystem)hdfs, (Path)new Path(path), (boolean)true, (Configuration)conf, null);
        PersistService.invoke("com.datastax.insight.agent.dao.InsightDAO", "saveFlowResult", new String[]{Integer.class.getTypeName(), String.class.getTypeName()}, new Object[]{PersistService.getFlowId(), path});
    }

    public static <T> void jdbc(Dataset<T> dataset, String mode, DBSource dbSource, String table) {
        if (dbSource != null) {
            Properties properties = new Properties();
            properties.put("driver", dbSource.getDriver());
            properties.put("user", dbSource.getUser());
            properties.put("password", dbSource.getPassword());
            dataset.write().mode(mode).jdbc(dbSource.getUrl(), table, properties);
        }
    }

    public static <T> void jdbc(Dataset<T> dataset, String mode, String dbID, String table) {
        DBSource dbSource = DataSetWriter.a(dbID);
        DataSetWriter.jdbc(dataset, mode, dbSource, table);
    }

    public static <T> void jdbc(Dataset<T> dataset, String mode, String url, String driver, String user, String password, String table) {
        Properties properties = new Properties();
        properties.put("driver", driver);
        properties.put("user", user);
        properties.put("password", password);
        if ("overwrite".equals(mode)) {
            dataset.write().mode(mode).option("truncate", true).option("batchsize", 1000L).jdbc(url, table, properties);
        } else {
            dataset.write().mode(mode).option("batchsize", 1000L).jdbc(url, table, properties);
        }
    }

    private static DBSource a(String id) {
        List dbSourceList = (List)Cache.getCache("dbsources");
        if (dbSourceList != null) {
            return dbSourceList.stream().filter(d2 -> d2.getId() == Integer.parseInt(id)).findFirst().orElse(null);
        }
        return null;
    }

    public static <T> void incrementDataSave(Dataset<T> dataset, String format, String mode, String path, String fileName, boolean withHeader) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        String nowDay = dateFormat.format(new Date());
        String rootPath = path.endsWith("/") ? path : path + "/";
        String savePath = rootPath + nowDay + "/" + fileName;
        DataFrameWriter writer = dataset.write();
        if (withHeader) {
            writer.option("header", true);
        }
        writer.format(format).mode(mode).save(savePath);
    }

    @InsightComponent(name="checkPoint", description="checkPoint")
    public static <T> Dataset<T> checkPoint(@InsightComponentArg(externalInput=true, name="\u6570\u636e\u96c6", description="\u6570\u636e\u96c6", defaultValue="${output}") Dataset<T> data, @InsightComponentArg(name="checkPoint\u5730\u5740", description="checkPoint\u5730\u5740") String address) {
        data.persist(StorageLevel.MEMORY_AND_DISK());
        SparkContextBuilder.getContext().setCheckpointDir(address);
        data.checkpoint();
        return data;
    }

    @InsightComponent(name="\u5220\u9664hdfs\u6587\u4ef6", description="\u5220\u9664hdfs\u6587\u4ef6")
    public static <T> Dataset<T> deleteHdfsFile(@InsightComponentArg(name="hdfs\u6587\u4ef6\u5730\u5740", description="hdfs\u6587\u4ef6\u5730\u5740", request=true) String hdfsFile) {
        try {
            FileSystem hdfs = FileSystem.get((URI)new URI(hdfsFile), (Configuration)new Configuration());
            Path path = new Path(hdfsFile);
            if (hdfs.exists(path)) {
                hdfs.delete(path, true);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return null;
    }

    @InsightComponent(name="Dataset Persist", description="Dataset Persist")
    public static <T> Dataset<T> persist(@InsightComponentArg(externalInput=true, name="\u6570\u636e\u96c6", description="\u6570\u636e\u96c6", defaultValue="${output}") Dataset<T> data, @InsightComponentArg(name="\u7f13\u5b58\u65b9\u5f0f", description="\u7f13\u5b58\u65b9\u5f0f", items="DISK_ONLY;DISK_ONLY_2;MEMORY_ONLY;MEMORY_ONLY_2;MEMORY_ONLY_SER;MEMORY_ONLY_SER_2;MEMORY_AND_DISK;MEMORY_AND_DISK_2;MEMORY_AND_DISK_SER;MEMORY_AND_DISK_SER_2") String persistMode) {
        StorageLevel mode = null;
        switch (persistMode) {
            case "DISK_ONLY": {
                mode = StorageLevel.DISK_ONLY();
                break;
            }
            case "DISK_ONLY_2": {
                mode = StorageLevel.DISK_ONLY_2();
                break;
            }
            case "MEMORY_ONLY": {
                mode = StorageLevel.MEMORY_ONLY();
                break;
            }
            case "MEMORY_ONLY_2": {
                mode = StorageLevel.MEMORY_ONLY_2();
                break;
            }
            case "MEMORY_ONLY_SER": {
                mode = StorageLevel.MEMORY_ONLY_SER();
                break;
            }
            case "MEMORY_ONLY_SER_2": {
                mode = StorageLevel.MEMORY_AND_DISK_SER_2();
                break;
            }
            case "DISK_ONLYDISK_ONLY": {
                mode = StorageLevel.MEMORY_AND_DISK();
                break;
            }
            case "MEMORY_AND_DISK_2": {
                mode = StorageLevel.MEMORY_AND_DISK_2();
                break;
            }
            default: {
                mode = StorageLevel.MEMORY_AND_DISK();
            }
        }
        data.persist(mode);
        return data;
    }

    @InsightComponent(name="Dataset Unpersist", description="Dataset Unpersist")
    public static <T> Dataset<T> unpersist(@InsightComponentArg(externalInput=true, name="\u6570\u636e\u96c6", description="\u6570\u636e\u96c6", defaultValue="${output}") Dataset<T> data) {
        data.unpersist();
        return data;
    }
}

